/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.util.List;
import org.apache.flink.client.python.PythonDriverOptions;
import org.apache.flink.client.python.PythonDriverOptionsParserFactory;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.junit.Assert;
import org.junit.Test;

public class PythonDriverOptionsParserFactoryTest {
    private static final CommandLineParser<PythonDriverOptions> commandLineParser = new CommandLineParser((ParserResultFactory)new PythonDriverOptionsParserFactory());

    @Test
    public void testPythonDriverOptionsParsing() throws FlinkParseException {
        String[] args = new String[]{"--python", "xxx.py", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test
    public void testPymoduleOptionParsing() throws FlinkParseException {
        String[] args = new String[]{"--pyModule", "xxx", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test
    public void testShortOptions() throws FlinkParseException {
        String[] args = new String[]{"-py", "xxx.py", "--input", "in.txt"};
        this.verifyPythonDriverOptionsParsing(args);
    }

    @Test(expected=FlinkParseException.class)
    public void testMultipleEntrypointsSpecified() throws FlinkParseException {
        String[] args = new String[]{"--python", "xxx.py", "--pyModule", "yyy", "--input", "in.txt"};
        commandLineParser.parse(args);
    }

    @Test(expected=FlinkParseException.class)
    public void testEntrypointNotSpecified() throws FlinkParseException {
        String[] args = new String[]{"--input", "in.txt"};
        commandLineParser.parse(args);
    }

    private void verifyPythonDriverOptionsParsing(String[] args) throws FlinkParseException {
        PythonDriverOptions pythonCommandOptions = (PythonDriverOptions)commandLineParser.parse(args);
        if (pythonCommandOptions.getEntryPointScript().isPresent()) {
            Assert.assertEquals((Object)"xxx.py", pythonCommandOptions.getEntryPointScript().get());
        } else {
            Assert.assertEquals((Object)"xxx", (Object)pythonCommandOptions.getEntryPointModule());
        }
        List programArgs = pythonCommandOptions.getProgramArgs();
        Assert.assertEquals((long)2L, (long)programArgs.size());
        Assert.assertEquals((Object)"--input", programArgs.get(0));
        Assert.assertEquals((Object)"in.txt", programArgs.get(1));
    }
}

