/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.flink.client.cli.ProgramOptionsUtils;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonOptions;
import org.junit.Assert;
import org.junit.Test;

public class PythonProgramOptionsITCase {
    @Test
    public void testConfigurePythonExecution() throws Exception {
        String[] args = new String[]{"--python", "xxx.py", "--pyModule", "xxx", "--pyFiles", "/absolute/a.py,relative/b.py,relative/c.py", "--pyRequirements", "d.txt#e_dir", "--pyExecutable", "/usr/bin/python", "--pyArchives", "g.zip,h.zip#data,h.zip#data2", "userarg1", "userarg2"};
        final File[] dummyJobJar = new File[]{null};
        Files.walkFileTree(FileSystems.getDefault().getPath(System.getProperty("user.dir") + "/dummy-job-jar", new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileVisitResult result = super.visitFile(file, attrs);
                if (file.getFileName().toString().startsWith("flink-python")) {
                    dummyJobJar[0] = file.toFile();
                }
                return result;
            }
        });
        PackagedProgram packagedProgram = PackagedProgram.newBuilder().setArguments(args).setJarFile(dummyJobJar[0]).build();
        Configuration configuration = new Configuration();
        ProgramOptionsUtils.configurePythonExecution((Configuration)configuration, (PackagedProgram)packagedProgram);
        Assert.assertEquals((Object)"/absolute/a.py,relative/b.py,relative/c.py", (Object)configuration.get(PythonOptions.PYTHON_FILES));
        Assert.assertEquals((Object)"d.txt#e_dir", (Object)configuration.get(PythonOptions.PYTHON_REQUIREMENTS));
        Assert.assertEquals((Object)"g.zip,h.zip#data,h.zip#data2", (Object)configuration.get(PythonOptions.PYTHON_ARCHIVES));
        Assert.assertEquals((Object)"/usr/bin/python", (Object)configuration.get(PythonOptions.PYTHON_EXECUTABLE));
        Assert.assertArrayEquals((Object[])new String[]{"--python", "xxx.py", "--pyModule", "xxx", "userarg1", "userarg2"}, (Object[])packagedProgram.getArguments());
    }
}

