/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils.serializers.python;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimestampSerializer;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimestampSerializerTest
extends SerializerTestBase<Timestamp> {
    private int precision;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {3}, {6}, {9});
    }

    public TimestampSerializerTest(int precision) {
        this.precision = precision;
    }

    protected TypeSerializer<Timestamp> createSerializer() {
        return new TimestampSerializer(this.precision);
    }

    protected int getLength() {
        return this.precision <= 3 ? 8 : 12;
    }

    protected Class<Timestamp> getTypeClass() {
        return Timestamp.class;
    }

    protected Timestamp[] getTestData() {
        return new Timestamp[]{Timestamp.valueOf("2018-03-11 03:00:00.123")};
    }
}

