/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.sql.Date;
import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.RowSerializer;
import org.apache.flink.fnexecution.v1.FlinkFnApi;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.runtime.typeutils.PythonTypeUtils;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.util.ExceptionUtils;
import org.junit.Assert;
import org.junit.Test;

public class PythonTypeUtilsTest {
    @Test
    public void testLogicalTypeToFlinkTypeSerializer() {
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        rowFields.add(new RowType.RowField("f1", (LogicalType)new BigIntType()));
        RowType rowType = new RowType(rowFields);
        TypeSerializer rowSerializer = PythonTypeUtils.toFlinkTypeSerializer((LogicalType)rowType);
        Assert.assertTrue((boolean)(rowSerializer instanceof RowSerializer));
        Assert.assertEquals((long)1L, (long)((RowSerializer)rowSerializer).getArity());
    }

    @Test
    public void testLogicalTypeToBlinkTypeSerializer() {
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        rowFields.add(new RowType.RowField("f1", (LogicalType)new BigIntType()));
        RowType rowType = new RowType(rowFields);
        TypeSerializer baseSerializer = PythonTypeUtils.toBlinkTypeSerializer((LogicalType)rowType);
        Assert.assertTrue((boolean)(baseSerializer instanceof RowDataSerializer));
        Assert.assertEquals((long)1L, (long)((RowDataSerializer)baseSerializer).getArity());
    }

    @Test
    public void testLogicalTypeToProto() {
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        rowFields.add(new RowType.RowField("f1", (LogicalType)new BigIntType()));
        RowType rowType = new RowType(rowFields);
        FlinkFnApi.Schema.FieldType protoType = (FlinkFnApi.Schema.FieldType)rowType.accept((LogicalTypeVisitor)new PythonTypeUtils.LogicalTypeToProtoTypeConverter());
        FlinkFnApi.Schema schema = protoType.getRowSchema();
        Assert.assertEquals((long)1L, (long)schema.getFieldsCount());
        Assert.assertEquals((Object)"f1", (Object)schema.getFields(0).getName());
        Assert.assertEquals((Object)FlinkFnApi.Schema.TypeName.BIGINT, (Object)schema.getFields(0).getType().getTypeName());
    }

    @Test
    public void testUnsupportedTypeSerializer() {
        UnresolvedUserDefinedType logicalType = new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"cat", "db", "MyType"}));
        String expectedTestException = "Python UDF doesn't support logical type `cat`.`db`.`MyType` currently.";
        try {
            PythonTypeUtils.toFlinkTypeSerializer((LogicalType)logicalType);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)ExceptionUtils.findThrowableWithMessage((Throwable)e, (String)expectedTestException).isPresent());
        }
    }

    @Test
    public void testLogicalTypeToConversionClassConverter() {
        PythonTypeUtils.LogicalTypeToConversionClassConverter converter = PythonTypeUtils.LogicalTypeToConversionClassConverter.INSTANCE;
        ArrayType arrayType = new ArrayType((LogicalType)new ArrayType((LogicalType)new DateType()));
        Class conversionClass = converter.visit(arrayType);
        Assert.assertEquals(Date[][].class, (Object)conversionClass);
    }
}

