/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.PythonFunctionRunner;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.functions.python.PythonFunctionInfo;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.AbstractArrowPythonAggregateFunctionOperator;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.AbstractBatchArrowPythonAggregateFunctionOperatorTest;
import org.apache.flink.table.runtime.operators.python.aggregate.arrow.batch.BatchArrowPythonGroupWindowAggregateFunctionOperator;
import org.apache.flink.table.runtime.utils.PassThroughPythonAggregateFunctionRunner;
import org.apache.flink.table.runtime.utils.PythonTestUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class BatchArrowPythonGroupWindowAggregateFunctionOperatorTest
extends AbstractBatchArrowPythonAggregateFunctionOperatorTest {
    @Test
    public void testGroupAggregateFunction() throws Exception {
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(new Configuration());
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 3L));
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testFinishBundleTriggeredByCount() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 6);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 3L));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testFinishBundleTriggeredByTime() throws Exception {
        Configuration conf = new Configuration();
        conf.setInteger(PythonOptions.MAX_BUNDLE_SIZE, 10);
        conf.setLong(PythonOptions.MAX_BUNDLE_TIME_MILLS, 1000L);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.getTestHarness(conf);
        long initialTime = 0L;
        ConcurrentLinkedQueue<Object> expectedOutput = new ConcurrentLinkedQueue<Object>();
        testHarness.open();
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c2", 0L, 0L), initialTime + 1L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c4", 1L, 6000L), initialTime + 2L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c1", "c6", 2L, 10000L), initialTime + 3L));
        testHarness.processElement(new StreamRecord((Object)this.newBinaryRow(true, "c2", "c8", 3L, 0L), initialTime + 3L));
        this.assertOutputEquals("FinishBundle should not be triggered.", expectedOutput, testHarness.getOutput());
        testHarness.setProcessingTime(1000L);
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 0L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 1L, TimestampData.fromEpochMillis((long)5000L), TimestampData.fromEpochMillis((long)15000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c1", 2L, TimestampData.fromEpochMillis((long)10000L), TimestampData.fromEpochMillis((long)20000L))));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
        testHarness.close();
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)-5000L), TimestampData.fromEpochMillis((long)5000L))));
        expectedOutput.add(new StreamRecord((Object)this.newRow(true, "c2", 3L, TimestampData.fromEpochMillis((long)0L), TimestampData.fromEpochMillis((long)10000L))));
        this.assertOutputEquals("Output was not correct.", expectedOutput, testHarness.getOutput());
    }

    @Override
    public LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    @Override
    public RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new VarCharType()), new RowType.RowField("f3", (LogicalType)new BigIntType()), new RowType.RowField("rowTime", (LogicalType)new BigIntType())));
    }

    @Override
    public RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new BigIntType()), new RowType.RowField("windowStart", (LogicalType)new TimestampType(3)), new RowType.RowField("windowEnd", (LogicalType)new TimestampType(3))));
    }

    @Override
    public AbstractArrowPythonAggregateFunctionOperator getTestOperator(Configuration config, PythonFunctionInfo[] pandasAggregateFunctions, RowType inputType, RowType outputType, int[] groupingSet, int[] udafInputOffsets) {
        return new PassThroughBatchArrowPythonGroupWindowAggregateFunctionOperator(config, pandasAggregateFunctions, inputType, outputType, 3, 100000, 10000L, 5000L, new int[]{0, 1}, groupingSet, groupingSet, udafInputOffsets);
    }

    private static class PassThroughBatchArrowPythonGroupWindowAggregateFunctionOperator
    extends BatchArrowPythonGroupWindowAggregateFunctionOperator {
        PassThroughBatchArrowPythonGroupWindowAggregateFunctionOperator(Configuration config, PythonFunctionInfo[] pandasAggFunctions, RowType inputType, RowType outputType, int inputTimeFieldIndex, int maxLimitSize, long windowSize, long slideSize, int[] namedProperties, int[] groupKey, int[] groupingSet, int[] udafInputOffsets) {
            super(config, pandasAggFunctions, inputType, outputType, inputTimeFieldIndex, maxLimitSize, windowSize, slideSize, namedProperties, groupKey, groupingSet, udafInputOffsets);
        }

        public PythonFunctionRunner createPythonFunctionRunner() {
            return new PassThroughPythonAggregateFunctionRunner(this.getRuntimeContext().getTaskName(), PythonTestUtils.createTestEnvironmentManager(), this.userDefinedFunctionInputType, this.userDefinedFunctionOutputType, this.getFunctionUrn(), this.getUserDefinedFunctionsProto(), this.getInputOutputCoderUrn(), new HashMap<String, String>(), PythonTestUtils.createMockFlinkMetricContainer(), false);
        }
    }
}

