/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.python.aggregate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.memory.ManagedMemoryUseCase;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.RowKind;

public abstract class AbstractPythonStreamAggregateOperatorTest {
    private RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(this.getOutputLogicalType());

    protected LogicalType[] getOutputLogicalType() {
        return new LogicalType[]{DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType()};
    }

    protected RowType getInputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new BigIntType())));
    }

    protected RowType getOutputType() {
        return new RowType(Arrays.asList(new RowType.RowField("f1", (LogicalType)new VarCharType()), new RowType.RowField("f2", (LogicalType)new BigIntType())));
    }

    private RowType getKeyType() {
        return new RowType(Collections.singletonList(new RowType.RowField("f1", (LogicalType)new VarCharType())));
    }

    int[] getGrouping() {
        return new int[]{0};
    }

    protected OneInputStreamOperatorTestHarness getTestHarness(Configuration config) throws Exception {
        RowType outputType = this.getOutputType();
        OneInputStreamOperator operator = this.getTestOperator(config);
        KeyedOneInputStreamOperatorTestHarness testHarness = new KeyedOneInputStreamOperatorTestHarness(operator, (KeySelector)KeySelectorUtil.getRowDataSelector((int[])this.getGrouping(), (InternalTypeInfo)InternalTypeInfo.of((RowType)this.getInputType())), (TypeInformation)InternalTypeInfo.of((RowType)this.getKeyType()), 1, 1, 0);
        testHarness.getStreamConfig().setManagedMemoryFractionOperatorOfUseCase(ManagedMemoryUseCase.PYTHON, 0.5);
        testHarness.setup((TypeSerializer)new RowDataSerializer(outputType));
        return testHarness;
    }

    protected RowData newRow(boolean accumulateMsg, Object ... fields) {
        if (accumulateMsg) {
            return StreamRecordUtils.row((Object[])fields);
        }
        RowData row = StreamRecordUtils.row((Object[])fields);
        row.setRowKind(RowKind.DELETE);
        return row;
    }

    protected void assertOutputEquals(String message, Collection<Object> expected, Collection<Object> actual) {
        this.assertor.assertOutputEquals(message, expected, actual);
    }

    abstract OneInputStreamOperator getTestOperator(Configuration var1);
}

