/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.RowSerializer;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.arrow.sources.AbstractArrowSourceFunction;
import org.apache.flink.table.runtime.arrow.sources.ArrowSourceFunctionTestBase;
import org.apache.flink.table.runtime.arrow.sources.RowArrowSourceFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.junit.BeforeClass;

public class RowArrowSourceFunctionTest
extends ArrowSourceFunctionTestBase<Row> {
    private static List<LogicalType> fieldTypes = new ArrayList<LogicalType>();
    private static RowType rowType;
    private static DataType dataType;
    private static BufferAllocator allocator;

    public RowArrowSourceFunctionTest() {
        super(VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator), new RowSerializer(new TypeSerializer[]{StringSerializer.INSTANCE}), Comparator.comparing(o -> (String)o.getField(0)));
    }

    @BeforeClass
    public static void init() {
        fieldTypes.add((LogicalType)new VarCharType());
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            rowFields.add(new RowType.RowField("f" + i, fieldTypes.get(i)));
        }
        rowType = new RowType(rowFields);
        dataType = TypeConversions.fromLogicalToDataType((LogicalType)rowType);
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Override
    public Tuple2<List<Row>, Integer> getTestData() {
        return Tuple2.of(Arrays.asList(Row.of((Object[])new Object[]{"aaa"}), Row.of((Object[])new Object[]{"bbb"}), Row.of((Object[])new Object[]{"ccc"}), Row.of((Object[])new Object[]{"ddd"}), Row.of((Object[])new Object[]{"eee"})), (Object)3);
    }

    @Override
    public ArrowWriter<Row> createArrowWriter() {
        return ArrowUtils.createRowArrowWriter((VectorSchemaRoot)this.root, (RowType)rowType);
    }

    @Override
    public AbstractArrowSourceFunction<Row> createArrowSourceFunction(byte[][] arrowData) {
        return new RowArrowSourceFunction(dataType, arrowData);
    }
}

