/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.java.tuple.Tuple7;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.arrow.readers.ArrayFieldReader;
import org.apache.flink.table.runtime.arrow.readers.ArrowFieldReader;
import org.apache.flink.table.runtime.arrow.readers.BigIntFieldReader;
import org.apache.flink.table.runtime.arrow.readers.BooleanFieldReader;
import org.apache.flink.table.runtime.arrow.readers.DateFieldReader;
import org.apache.flink.table.runtime.arrow.readers.DecimalFieldReader;
import org.apache.flink.table.runtime.arrow.readers.DoubleFieldReader;
import org.apache.flink.table.runtime.arrow.readers.FloatFieldReader;
import org.apache.flink.table.runtime.arrow.readers.IntFieldReader;
import org.apache.flink.table.runtime.arrow.readers.RowArrowReader;
import org.apache.flink.table.runtime.arrow.readers.RowFieldReader;
import org.apache.flink.table.runtime.arrow.readers.SmallIntFieldReader;
import org.apache.flink.table.runtime.arrow.readers.TimeFieldReader;
import org.apache.flink.table.runtime.arrow.readers.TimestampFieldReader;
import org.apache.flink.table.runtime.arrow.readers.TinyIntFieldReader;
import org.apache.flink.table.runtime.arrow.readers.VarBinaryFieldReader;
import org.apache.flink.table.runtime.arrow.readers.VarCharFieldReader;
import org.apache.flink.table.runtime.arrow.vectors.ArrowArrayColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowBigIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowBooleanColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDateColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDecimalColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowDoubleColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowFloatColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowRowColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowSmallIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTimeColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTimestampColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowTinyIntColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowVarBinaryColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.ArrowVarCharColumnVector;
import org.apache.flink.table.runtime.arrow.vectors.RowDataArrowReader;
import org.apache.flink.table.runtime.arrow.writers.ArrayWriter;
import org.apache.flink.table.runtime.arrow.writers.ArrowFieldWriter;
import org.apache.flink.table.runtime.arrow.writers.BigIntWriter;
import org.apache.flink.table.runtime.arrow.writers.BooleanWriter;
import org.apache.flink.table.runtime.arrow.writers.DateWriter;
import org.apache.flink.table.runtime.arrow.writers.DecimalWriter;
import org.apache.flink.table.runtime.arrow.writers.DoubleWriter;
import org.apache.flink.table.runtime.arrow.writers.FloatWriter;
import org.apache.flink.table.runtime.arrow.writers.IntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowArrayWriter;
import org.apache.flink.table.runtime.arrow.writers.RowBigIntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowBooleanWriter;
import org.apache.flink.table.runtime.arrow.writers.RowDateWriter;
import org.apache.flink.table.runtime.arrow.writers.RowDecimalWriter;
import org.apache.flink.table.runtime.arrow.writers.RowDoubleWriter;
import org.apache.flink.table.runtime.arrow.writers.RowFloatWriter;
import org.apache.flink.table.runtime.arrow.writers.RowIntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowRowWriter;
import org.apache.flink.table.runtime.arrow.writers.RowSmallIntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowTimeWriter;
import org.apache.flink.table.runtime.arrow.writers.RowTimestampWriter;
import org.apache.flink.table.runtime.arrow.writers.RowTinyIntWriter;
import org.apache.flink.table.runtime.arrow.writers.RowVarBinaryWriter;
import org.apache.flink.table.runtime.arrow.writers.RowVarCharWriter;
import org.apache.flink.table.runtime.arrow.writers.RowWriter;
import org.apache.flink.table.runtime.arrow.writers.SmallIntWriter;
import org.apache.flink.table.runtime.arrow.writers.TimeWriter;
import org.apache.flink.table.runtime.arrow.writers.TimestampWriter;
import org.apache.flink.table.runtime.arrow.writers.TinyIntWriter;
import org.apache.flink.table.runtime.arrow.writers.VarBinaryWriter;
import org.apache.flink.table.runtime.arrow.writers.VarCharWriter;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ArrowUtilsTest {
    private static List<Tuple7<String, LogicalType, ArrowType, Class<?>, Class<?>, Class<?>, Class<?>>> testFields;
    private static RowType rowType;
    private static BufferAllocator allocator;

    @BeforeClass
    public static void init() {
        testFields = new ArrayList();
        testFields.add(Tuple7.of((Object)"f1", (Object)new TinyIntType(), (Object)new ArrowType.Int(8, true), RowTinyIntWriter.class, TinyIntWriter.TinyIntWriterForRow.class, TinyIntFieldReader.class, ArrowTinyIntColumnVector.class));
        testFields.add(Tuple7.of((Object)"f2", (Object)new SmallIntType(), (Object)new ArrowType.Int(16, true), RowSmallIntWriter.class, SmallIntWriter.SmallIntWriterForRow.class, SmallIntFieldReader.class, ArrowSmallIntColumnVector.class));
        testFields.add(Tuple7.of((Object)"f3", (Object)new IntType(), (Object)new ArrowType.Int(32, true), RowIntWriter.class, IntWriter.IntWriterForRow.class, IntFieldReader.class, ArrowIntColumnVector.class));
        testFields.add(Tuple7.of((Object)"f4", (Object)new BigIntType(), (Object)new ArrowType.Int(64, true), RowBigIntWriter.class, BigIntWriter.BigIntWriterForRow.class, BigIntFieldReader.class, ArrowBigIntColumnVector.class));
        testFields.add(Tuple7.of((Object)"f5", (Object)new BooleanType(), (Object)new ArrowType.Bool(), RowBooleanWriter.class, BooleanWriter.BooleanWriterForRow.class, BooleanFieldReader.class, ArrowBooleanColumnVector.class));
        testFields.add(Tuple7.of((Object)"f6", (Object)new FloatType(), (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE), RowFloatWriter.class, FloatWriter.FloatWriterForRow.class, FloatFieldReader.class, ArrowFloatColumnVector.class));
        testFields.add(Tuple7.of((Object)"f7", (Object)new DoubleType(), (Object)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE), RowDoubleWriter.class, DoubleWriter.DoubleWriterForRow.class, DoubleFieldReader.class, ArrowDoubleColumnVector.class));
        testFields.add(Tuple7.of((Object)"f8", (Object)new VarCharType(), (Object)ArrowType.Utf8.INSTANCE, RowVarCharWriter.class, VarCharWriter.VarCharWriterForRow.class, VarCharFieldReader.class, ArrowVarCharColumnVector.class));
        testFields.add(Tuple7.of((Object)"f9", (Object)new VarBinaryType(), (Object)ArrowType.Binary.INSTANCE, RowVarBinaryWriter.class, VarBinaryWriter.VarBinaryWriterForRow.class, VarBinaryFieldReader.class, ArrowVarBinaryColumnVector.class));
        testFields.add(Tuple7.of((Object)"f10", (Object)new DecimalType(10, 3), (Object)new ArrowType.Decimal(10, 3), RowDecimalWriter.class, DecimalWriter.DecimalWriterForRow.class, DecimalFieldReader.class, ArrowDecimalColumnVector.class));
        testFields.add(Tuple7.of((Object)"f11", (Object)new DateType(), (Object)new ArrowType.Date(DateUnit.DAY), RowDateWriter.class, DateWriter.DateWriterForRow.class, DateFieldReader.class, ArrowDateColumnVector.class));
        testFields.add(Tuple7.of((Object)"f13", (Object)new TimeType(0), (Object)new ArrowType.Time(TimeUnit.SECOND, 32), RowTimeWriter.class, TimeWriter.TimeWriterForRow.class, TimeFieldReader.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple7.of((Object)"f14", (Object)new TimeType(2), (Object)new ArrowType.Time(TimeUnit.MILLISECOND, 32), RowTimeWriter.class, TimeWriter.TimeWriterForRow.class, TimeFieldReader.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple7.of((Object)"f15", (Object)new TimeType(4), (Object)new ArrowType.Time(TimeUnit.MICROSECOND, 64), RowTimeWriter.class, TimeWriter.TimeWriterForRow.class, TimeFieldReader.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple7.of((Object)"f16", (Object)new TimeType(8), (Object)new ArrowType.Time(TimeUnit.NANOSECOND, 64), RowTimeWriter.class, TimeWriter.TimeWriterForRow.class, TimeFieldReader.class, ArrowTimeColumnVector.class));
        testFields.add(Tuple7.of((Object)"f17", (Object)new LocalZonedTimestampType(0), (Object)new ArrowType.Timestamp(TimeUnit.SECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f18", (Object)new LocalZonedTimestampType(2), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f19", (Object)new LocalZonedTimestampType(4), (Object)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f20", (Object)new LocalZonedTimestampType(8), (Object)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f21", (Object)new TimestampType(0), (Object)new ArrowType.Timestamp(TimeUnit.SECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f22", (Object)new TimestampType(2), (Object)new ArrowType.Timestamp(TimeUnit.MILLISECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f23", (Object)new TimestampType(4), (Object)new ArrowType.Timestamp(TimeUnit.MICROSECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f24", (Object)new TimestampType(8), (Object)new ArrowType.Timestamp(TimeUnit.NANOSECOND, null), RowTimestampWriter.class, TimestampWriter.TimestampWriterForRow.class, TimestampFieldReader.class, ArrowTimestampColumnVector.class));
        testFields.add(Tuple7.of((Object)"f25", (Object)new ArrayType((LogicalType)new VarCharType()), (Object)ArrowType.List.INSTANCE, RowArrayWriter.class, ArrayWriter.ArrayWriterForRow.class, ArrayFieldReader.class, ArrowArrayColumnVector.class));
        RowType rowFieldType = new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new IntType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new ArrayType((LogicalType)new VarCharType())), new RowType.RowField("d", (LogicalType)new TimestampType(2)), new RowType.RowField("e", (LogicalType)new RowType(Arrays.asList(new RowType.RowField("e1", (LogicalType)new IntType()), new RowType.RowField("e2", (LogicalType)new VarCharType()))))));
        testFields.add(Tuple7.of((Object)"f26", (Object)rowFieldType, (Object)ArrowType.Struct.INSTANCE, RowRowWriter.class, RowWriter.RowWriterForRow.class, RowFieldReader.class, ArrowRowColumnVector.class));
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (Tuple7<String, LogicalType, ArrowType, Class<?>, Class<?>, Class<?>, Class<?>> field : testFields) {
            rowFields.add(new RowType.RowField((String)field.f0, (LogicalType)field.f1));
        }
        rowType = new RowType(rowFields);
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Test
    public void testConvertBetweenLogicalTypeAndArrowType() {
        Schema schema = ArrowUtils.toArrowSchema((RowType)rowType);
        Assert.assertEquals((long)testFields.size(), (long)schema.getFields().size());
        List fields = schema.getFields();
        for (int i = 0; i < schema.getFields().size(); ++i) {
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f0, (Object)((Field)fields.get(i)).getName());
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f2, (Object)((Field)fields.get(i)).getType());
        }
    }

    @Test
    public void testCreateRowArrowReader() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        RowArrowReader reader = ArrowUtils.createRowArrowReader((VectorSchemaRoot)root, (RowType)rowType);
        ArrowFieldReader[] fieldReaders = reader.getFieldReaders();
        for (int i = 0; i < fieldReaders.length; ++i) {
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f5, fieldReaders[i].getClass());
        }
    }

    @Test
    public void testCreateRowDataArrowReader() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        RowDataArrowReader reader = ArrowUtils.createRowDataArrowReader((VectorSchemaRoot)root, (RowType)rowType);
        ColumnVector[] columnVectors = reader.getColumnVectors();
        for (int i = 0; i < columnVectors.length; ++i) {
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f6, columnVectors[i].getClass());
        }
    }

    @Test
    public void testCreateRowArrowWriter() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter writer = ArrowUtils.createRowArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ArrowFieldWriter[] fieldWriters = writer.getFieldWriters();
        for (int i = 0; i < fieldWriters.length; ++i) {
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f3, fieldWriters[i].getClass());
        }
    }

    @Test
    public void testCreateRowDataArrowWriter() {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter writer = ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ArrowFieldWriter[] fieldWriters = writer.getFieldWriters();
        for (int i = 0; i < fieldWriters.length; ++i) {
            Assert.assertEquals((Object)ArrowUtilsTest.testFields.get((int)i).f4, fieldWriters[i].getClass());
        }
    }

    @Test
    public void testReadArrowBatches() throws IOException {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter arrowWriter = ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrowStreamWriter arrowStreamWriter = new ArrowStreamWriter(root, null, (OutputStream)baos);
        arrowStreamWriter.start();
        List<RowData> testData = Arrays.asList(new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()), new GenericRowData(rowType.getFieldCount()));
        int batches = 3;
        List subLists = Lists.partition(testData, (int)(testData.size() / batches + 1));
        for (List subList : subLists) {
            for (RowData value : subList) {
                arrowWriter.write((Object)value);
            }
            arrowWriter.finish();
            arrowStreamWriter.writeBatch();
            arrowWriter.reset();
        }
        Assert.assertEquals((long)batches, (long)ArrowUtils.readArrowBatches((ReadableByteChannel)Channels.newChannel(new ByteArrayInputStream(baos.toByteArray()))).length);
    }
}

