/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.python;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.client.python.PythonDriver;
import org.apache.flink.client.python.PythonDriverOptions;
import org.apache.flink.client.python.PythonEnvUtils;
import org.junit.Assert;
import org.junit.Test;
import py4j.GatewayServer;

public class PythonDriverTest {
    @Test
    public void testStartGatewayServer() throws ExecutionException, InterruptedException {
        GatewayServer gatewayServer = PythonEnvUtils.startGatewayServer();
        try {
            Socket socket = new Socket("localhost", gatewayServer.getListeningPort());
            assert (socket.isConnected());
        }
        catch (IOException e) {
            throw new RuntimeException("Connect Gateway Server failed");
        }
        finally {
            gatewayServer.shutdown();
        }
    }

    @Test
    public void testConstructCommandsWithEntryPointModule() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--input");
        args.add("in.txt");
        PythonDriverOptions pythonDriverOptions = new PythonDriverOptions("xxx", null, args);
        List commands = PythonDriver.constructPythonCommands((PythonDriverOptions)pythonDriverOptions);
        Assert.assertEquals((long)4L, (long)commands.size());
        Assert.assertEquals(commands.get(0), (Object)"-m");
        Assert.assertEquals(commands.get(1), (Object)"xxx");
        Assert.assertEquals(commands.get(2), (Object)"--input");
        Assert.assertEquals(commands.get(3), (Object)"in.txt");
    }

    @Test
    public void testConstructCommandsWithEntryPointScript() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("--input");
        args.add("in.txt");
        PythonDriverOptions pythonDriverOptions = new PythonDriverOptions(null, "xxx", args);
        List commands = PythonDriver.constructPythonCommands((PythonDriverOptions)pythonDriverOptions);
        Assert.assertEquals((long)3L, (long)commands.size());
        Assert.assertEquals(commands.get(0), (Object)"xxx");
        Assert.assertEquals(commands.get(1), (Object)"--input");
        Assert.assertEquals(commands.get(2), (Object)"in.txt");
    }
}

