/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.util;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.python.api.types.CustomTypeWrapper;

public class SerializationUtils {
    public static final byte TYPE_BOOLEAN = 34;
    public static final byte TYPE_BYTE = 33;
    public static final byte TYPE_INTEGER = 32;
    public static final byte TYPE_LONG = 31;
    public static final byte TYPE_DOUBLE = 30;
    public static final byte TYPE_FLOAT = 29;
    public static final byte TYPE_STRING = 28;
    public static final byte TYPE_BYTES = 27;
    public static final byte TYPE_NULL = 26;

    public static Serializer getSerializer(Object value) {
        String className = value.getClass().getSimpleName().toUpperCase();
        if (className.startsWith("TUPLE")) {
            className = "TUPLE";
        }
        if (className.startsWith("BYTE[]")) {
            className = "BYTES";
        }
        SupportedTypes type = SupportedTypes.valueOf(className);
        switch (type) {
            case TUPLE: {
                return new TupleSerializer((Tuple)value);
            }
            case BOOLEAN: {
                return new BooleanSerializer();
            }
            case BYTE: {
                return new ByteSerializer();
            }
            case BYTES: {
                return new BytesSerializer();
            }
            case INTEGER: {
                return new IntSerializer();
            }
            case LONG: {
                return new LongSerializer();
            }
            case STRING: {
                return new StringSerializer();
            }
            case FLOAT: {
                return new FloatSerializer();
            }
            case DOUBLE: {
                return new DoubleSerializer();
            }
            case NULL: {
                return new NullSerializer();
            }
            case CUSTOMTYPEWRAPPER: {
                return new CustomTypeWrapperSerializer((CustomTypeWrapper)value);
            }
        }
        throw new IllegalArgumentException("Unsupported Type encountered: " + (Object)((Object)type));
    }

    public static class TupleSerializer
    extends Serializer<Tuple> {
        private final Serializer[] serializer;

        public TupleSerializer(Tuple value) {
            this.serializer = new Serializer[value.getArity()];
            for (int x = 0; x < this.serializer.length; ++x) {
                this.serializer[x] = SerializationUtils.getSerializer(value.getField(x));
            }
        }

        @Override
        public byte[] serializeWithoutTypeInfo(Tuple value) {
            ArrayList<byte[]> bits = new ArrayList<byte[]>();
            int totalSize = 0;
            for (int x = 0; x < this.serializer.length; ++x) {
                byte[] bit = this.serializer[x].serializeWithoutTypeInfo(value.getField(x));
                bits.add(bit);
                totalSize += bit.length;
            }
            int pointer = 0;
            byte[] data = new byte[totalSize];
            for (byte[] bit : bits) {
                System.arraycopy(bit, 0, data, pointer, bit.length);
                pointer += bit.length;
            }
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)this.serializer.length);
            for (Serializer s : this.serializer) {
                s.putTypeInfo(buffer);
            }
        }

        @Override
        public int getTypeInfoSize() {
            int size = 1;
            for (Serializer s : this.serializer) {
                size += s.getTypeInfoSize();
            }
            return size;
        }
    }

    public static class BytesSerializer
    extends Serializer<byte[]> {
        @Override
        public byte[] serializeWithoutTypeInfo(byte[] value) {
            byte[] data = new byte[4 + value.length];
            ByteBuffer.wrap(data).putInt(value.length).put(value);
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)27);
        }
    }

    public static class NullSerializer
    extends Serializer<Object> {
        @Override
        public byte[] serializeWithoutTypeInfo(Object value) {
            return new byte[0];
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)26);
        }
    }

    public static class DoubleSerializer
    extends Serializer<Double> {
        @Override
        public byte[] serializeWithoutTypeInfo(Double value) {
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putDouble(value);
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)30);
        }
    }

    public static class FloatSerializer
    extends Serializer<Float> {
        @Override
        public byte[] serializeWithoutTypeInfo(Float value) {
            byte[] data = new byte[4];
            ByteBuffer.wrap(data).putFloat(value.floatValue());
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)29);
        }
    }

    public static class StringSerializer
    extends Serializer<String> {
        @Override
        public byte[] serializeWithoutTypeInfo(String value) {
            byte[] string = value.getBytes();
            byte[] data = new byte[4 + string.length];
            ByteBuffer.wrap(data).putInt(string.length).put(string);
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)28);
        }
    }

    public static class LongSerializer
    extends Serializer<Long> {
        @Override
        public byte[] serializeWithoutTypeInfo(Long value) {
            byte[] data = new byte[8];
            ByteBuffer.wrap(data).putLong(value);
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)31);
        }
    }

    public static class IntSerializer
    extends Serializer<Integer> {
        @Override
        public byte[] serializeWithoutTypeInfo(Integer value) {
            byte[] data = new byte[4];
            ByteBuffer.wrap(data).putInt(value);
            return data;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)32);
        }
    }

    public static class BooleanSerializer
    extends Serializer<Boolean> {
        @Override
        public byte[] serializeWithoutTypeInfo(Boolean value) {
            return new byte[]{value != false ? (byte)1 : 0};
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)34);
        }
    }

    public static class ByteSerializer
    extends Serializer<Byte> {
        @Override
        public byte[] serializeWithoutTypeInfo(Byte value) {
            return new byte[]{value};
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put((byte)33);
        }
    }

    public static class CustomTypeWrapperSerializer
    extends Serializer<CustomTypeWrapper> {
        private final byte type;

        public CustomTypeWrapperSerializer(CustomTypeWrapper value) {
            this.type = value.getType();
        }

        @Override
        public byte[] serializeWithoutTypeInfo(CustomTypeWrapper value) {
            byte[] result = new byte[4 + value.getData().length];
            ByteBuffer.wrap(result).putInt(value.getData().length).put(value.getData());
            return result;
        }

        @Override
        public void putTypeInfo(ByteBuffer buffer) {
            buffer.put(this.type);
        }
    }

    public static abstract class Serializer<IN> {
        private byte[] typeInfo = null;

        public byte[] serialize(IN value) {
            if (this.typeInfo == null) {
                this.typeInfo = new byte[this.getTypeInfoSize()];
                ByteBuffer typeBuffer = ByteBuffer.wrap(this.typeInfo);
                this.putTypeInfo(typeBuffer);
            }
            byte[] bytes = this.serializeWithoutTypeInfo(value);
            byte[] total = new byte[this.typeInfo.length + bytes.length];
            ByteBuffer.wrap(total).put(this.typeInfo).put(bytes);
            return total;
        }

        public abstract byte[] serializeWithoutTypeInfo(IN var1);

        protected abstract void putTypeInfo(ByteBuffer var1);

        protected int getTypeInfoSize() {
            return 1;
        }
    }

    private static enum SupportedTypes {
        TUPLE,
        BOOLEAN,
        BYTE,
        BYTES,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        NULL,
        CUSTOMTYPEWRAPPER;

    }
}

