/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.plan;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.python.api.streaming.data.PythonReceiver;
import org.apache.flink.python.api.types.CustomTypeWrapper;

public class PythonPlanReceiver
implements Serializable {
    private final DataInputStream input;

    public PythonPlanReceiver(InputStream input) {
        this.input = new DataInputStream(input);
    }

    public Object getRecord() throws IOException {
        return this.getRecord(false);
    }

    public Object getRecord(boolean normalized) throws IOException {
        return this.getDeserializer().deserialize(normalized);
    }

    private Deserializer getDeserializer() throws IOException {
        byte type = this.input.readByte();
        if (type >= 0 && type < 26) {
            Deserializer[] d = new Deserializer[type];
            for (int x = 0; x < d.length; ++x) {
                d[x] = this.getDeserializer();
            }
            return new TupleDeserializer(d);
        }
        switch (type) {
            case 34: {
                return new BooleanDeserializer();
            }
            case 33: {
                return new ByteDeserializer();
            }
            case 32: {
                return new IntDeserializer();
            }
            case 31: {
                return new LongDeserializer();
            }
            case 29: {
                return new FloatDeserializer();
            }
            case 30: {
                return new DoubleDeserializer();
            }
            case 28: {
                return new StringDeserializer();
            }
            case 27: {
                return new BytesDeserializer();
            }
            case 26: {
                return new NullDeserializer();
            }
        }
        return new CustomTypeDeserializer(type);
    }

    private class BytesDeserializer
    extends Deserializer<byte[]> {
        private BytesDeserializer() {
        }

        @Override
        public byte[] deserialize(boolean normalized) throws IOException {
            int size = PythonPlanReceiver.this.input.readInt();
            byte[] buffer = new byte[size];
            PythonPlanReceiver.this.input.readFully(buffer);
            return buffer;
        }
    }

    private class NullDeserializer
    extends Deserializer<Object> {
        private NullDeserializer() {
        }

        @Override
        public Object deserialize(boolean normalized) throws IOException {
            return null;
        }
    }

    private class StringDeserializer
    extends Deserializer<String> {
        private StringDeserializer() {
        }

        @Override
        public String deserialize(boolean normalized) throws IOException {
            int size = PythonPlanReceiver.this.input.readInt();
            byte[] buffer = new byte[size];
            PythonPlanReceiver.this.input.readFully(buffer);
            return new String(buffer);
        }
    }

    private class DoubleDeserializer
    extends Deserializer<Double> {
        private DoubleDeserializer() {
        }

        @Override
        public Double deserialize(boolean normalized) throws IOException {
            return PythonPlanReceiver.this.input.readDouble();
        }
    }

    private class FloatDeserializer
    extends Deserializer<Object> {
        private FloatDeserializer() {
        }

        @Override
        public Object deserialize(boolean normalized) throws IOException {
            if (normalized) {
                return (double)PythonPlanReceiver.this.input.readFloat();
            }
            return Float.valueOf(PythonPlanReceiver.this.input.readFloat());
        }
    }

    private class LongDeserializer
    extends Deserializer<Object> {
        private LongDeserializer() {
        }

        @Override
        public Object deserialize(boolean normalized) throws IOException {
            if (normalized) {
                return new Long(PythonPlanReceiver.this.input.readLong()).intValue();
            }
            return PythonPlanReceiver.this.input.readLong();
        }
    }

    private class IntDeserializer
    extends Deserializer<Integer> {
        private IntDeserializer() {
        }

        @Override
        public Integer deserialize(boolean normalized) throws IOException {
            return PythonPlanReceiver.this.input.readInt();
        }
    }

    private class ByteDeserializer
    extends Deserializer<Byte> {
        private ByteDeserializer() {
        }

        @Override
        public Byte deserialize(boolean normalized) throws IOException {
            return PythonPlanReceiver.this.input.readByte();
        }
    }

    private class BooleanDeserializer
    extends Deserializer<Boolean> {
        private BooleanDeserializer() {
        }

        @Override
        public Boolean deserialize(boolean normalized) throws IOException {
            return PythonPlanReceiver.this.input.readBoolean();
        }
    }

    private class CustomTypeDeserializer
    extends Deserializer<CustomTypeWrapper> {
        private final byte type;

        public CustomTypeDeserializer(byte type) {
            this.type = type;
        }

        @Override
        public CustomTypeWrapper deserialize(boolean normalized) throws IOException {
            int size = PythonPlanReceiver.this.input.readInt();
            byte[] data = new byte[size];
            PythonPlanReceiver.this.input.readFully(data);
            return new CustomTypeWrapper(this.type, data);
        }
    }

    private class TupleDeserializer
    extends Deserializer<Tuple> {
        Deserializer[] deserializer;

        public TupleDeserializer(Deserializer[] deserializer) {
            this.deserializer = deserializer;
        }

        @Override
        public Tuple deserialize(boolean normalized) throws IOException {
            Tuple result = PythonReceiver.createTuple(this.deserializer.length);
            for (int x = 0; x < result.getArity(); ++x) {
                result.setField(this.deserializer[x].deserialize(normalized), x);
            }
            return result;
        }
    }

    private abstract class Deserializer<T> {
        private Deserializer() {
        }

        public T deserialize() throws IOException {
            return this.deserialize(false);
        }

        public abstract T deserialize(boolean var1) throws IOException;
    }
}

