/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.python.api.PythonPlanBinder;
import org.apache.flink.util.Collector;

public class PythonReceiver
implements Serializable {
    private static final long serialVersionUID = -2474088929850009968L;
    private File inputFile;
    private RandomAccessFile inputRAF;
    private FileChannel inputChannel;
    private MappedByteBuffer fileBuffer;
    private final boolean readAsByteArray;
    private Deserializer<?> deserializer = null;

    public PythonReceiver(boolean usesByteArray) {
        this.readAsByteArray = usesByteArray;
    }

    public void open(String path) throws IOException {
        this.setupMappedFile(path);
        this.deserializer = this.readAsByteArray ? new ByteArrayDeserializer() : new TupleDeserializer();
    }

    private void setupMappedFile(String inputFilePath) throws FileNotFoundException, IOException {
        File x = new File(PythonPlanBinder.FLINK_TMP_DATA_DIR);
        x.mkdirs();
        this.inputFile = new File(inputFilePath);
        if (this.inputFile.exists()) {
            this.inputFile.delete();
        }
        this.inputFile.createNewFile();
        this.inputRAF = new RandomAccessFile(inputFilePath, "rw");
        this.inputRAF.setLength(0x4000000L);
        this.inputRAF.seek(0x3FFFFFFL);
        this.inputRAF.writeByte(0);
        this.inputRAF.seek(0L);
        this.inputChannel = this.inputRAF.getChannel();
        this.fileBuffer = this.inputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x4000000L);
    }

    public void close() throws IOException {
        this.closeMappedFile();
    }

    private void closeMappedFile() throws IOException {
        this.inputChannel.close();
        this.inputRAF.close();
    }

    public void collectBuffer(Collector c, int bufferSize) throws IOException {
        this.fileBuffer.position(0);
        while (this.fileBuffer.position() < bufferSize) {
            c.collect(this.deserializer.deserialize());
        }
    }

    public static Tuple createTuple(int size) {
        try {
            return (Tuple)Tuple.getTupleClass((int)size).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private class TupleDeserializer
    implements Deserializer<Tuple2<Tuple, byte[]>> {
        private TupleDeserializer() {
        }

        @Override
        public Tuple2<Tuple, byte[]> deserialize() {
            int keyTupleSize = PythonReceiver.this.fileBuffer.get();
            Tuple keys = PythonReceiver.createTuple(keyTupleSize);
            for (int x = 0; x < keyTupleSize; ++x) {
                byte[] data = new byte[PythonReceiver.this.fileBuffer.getInt()];
                PythonReceiver.this.fileBuffer.get(data);
                keys.setField((Object)data, x);
            }
            byte[] value = new byte[PythonReceiver.this.fileBuffer.getInt()];
            PythonReceiver.this.fileBuffer.get(value);
            return new Tuple2((Object)keys, (Object)value);
        }
    }

    private class ByteArrayDeserializer
    implements Deserializer<byte[]> {
        private ByteArrayDeserializer() {
        }

        @Override
        public byte[] deserialize() {
            int size = PythonReceiver.this.fileBuffer.getInt();
            byte[] value = new byte[size];
            PythonReceiver.this.fileBuffer.get(value);
            return value;
        }
    }

    private static interface Deserializer<T> {
        public T deserialize();
    }
}

