/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.python.api.streaming.plan.PythonPlanStreamer;

public class PythonOperationInfo {
    public String identifier;
    public int parentID;
    public int otherID;
    public int setID;
    public String[] keys;
    public String[] keys1;
    public String[] keys2;
    public TypeInformation<?> types;
    public Object[] values;
    public int count;
    public String field;
    public Order order;
    public String path;
    public String fieldDelimiter;
    public String lineDelimiter;
    public long frm;
    public long to;
    public FileSystem.WriteMode writeMode;
    public boolean toError;
    public String name;
    public boolean usesUDF;
    public int parallelism;

    public PythonOperationInfo(PythonPlanStreamer streamer) throws IOException {
        this.identifier = (String)streamer.getRecord();
        this.parentID = (Integer)streamer.getRecord(true);
        this.otherID = (Integer)streamer.getRecord(true);
        this.field = "f0.f" + (Integer)streamer.getRecord(true);
        int encodedOrder = (Integer)streamer.getRecord(true);
        switch (encodedOrder) {
            case 0: {
                this.order = Order.NONE;
                break;
            }
            case 1: {
                this.order = Order.ASCENDING;
                break;
            }
            case 2: {
                this.order = Order.DESCENDING;
                break;
            }
            case 3: {
                this.order = Order.ANY;
                break;
            }
            default: {
                this.order = Order.NONE;
            }
        }
        this.keys = PythonOperationInfo.normalizeKeys(streamer.getRecord(true));
        this.keys1 = PythonOperationInfo.normalizeKeys(streamer.getRecord(true));
        this.keys2 = PythonOperationInfo.normalizeKeys(streamer.getRecord(true));
        Object tmpType = streamer.getRecord();
        this.types = tmpType == null ? null : TypeExtractor.getForObject((Object)tmpType);
        this.usesUDF = (Boolean)streamer.getRecord();
        this.name = (String)streamer.getRecord();
        this.lineDelimiter = (String)streamer.getRecord();
        this.fieldDelimiter = (String)streamer.getRecord();
        this.writeMode = (Integer)streamer.getRecord(true) == 1 ? FileSystem.WriteMode.OVERWRITE : FileSystem.WriteMode.NO_OVERWRITE;
        this.path = (String)streamer.getRecord();
        this.frm = (Long)streamer.getRecord();
        this.to = (Long)streamer.getRecord();
        this.setID = (Integer)streamer.getRecord(true);
        this.toError = (Boolean)streamer.getRecord();
        this.count = (Integer)streamer.getRecord(true);
        int valueCount = (Integer)streamer.getRecord(true);
        this.values = new Object[valueCount];
        for (int x = 0; x < valueCount; ++x) {
            this.values[x] = streamer.getRecord();
        }
        this.parallelism = (Integer)streamer.getRecord(true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SetID: ").append(this.setID).append("\n");
        sb.append("ParentID: ").append(this.parentID).append("\n");
        sb.append("OtherID: ").append(this.otherID).append("\n");
        sb.append("Name: ").append(this.name).append("\n");
        sb.append("Types: ").append(this.types).append("\n");
        sb.append("Keys1: ").append(Arrays.toString(this.keys1)).append("\n");
        sb.append("Keys2: ").append(Arrays.toString(this.keys2)).append("\n");
        sb.append("Keys: ").append(Arrays.toString(this.keys)).append("\n");
        sb.append("Count: ").append(this.count).append("\n");
        sb.append("Field: ").append(this.field).append("\n");
        sb.append("Order: ").append(this.order.toString()).append("\n");
        sb.append("Path: ").append(this.path).append("\n");
        sb.append("FieldDelimiter: ").append(this.fieldDelimiter).append("\n");
        sb.append("LineDelimiter: ").append(this.lineDelimiter).append("\n");
        sb.append("From: ").append(this.frm).append("\n");
        sb.append("To: ").append(this.to).append("\n");
        sb.append("WriteMode: ").append(this.writeMode).append("\n");
        sb.append("toError: ").append(this.toError).append("\n");
        return sb.toString();
    }

    private static String[] normalizeKeys(Object keys) {
        if (keys instanceof Tuple) {
            Tuple tupleKeys = (Tuple)keys;
            if (tupleKeys.getArity() == 0) {
                return new String[0];
            }
            if (tupleKeys.getField(0) instanceof Integer) {
                String[] stringKeys = new String[tupleKeys.getArity()];
                for (int x = 0; x < stringKeys.length; ++x) {
                    stringKeys[x] = "f0.f" + (Integer)tupleKeys.getField(x);
                }
                return stringKeys;
            }
            if (tupleKeys.getField(0) instanceof String) {
                return PythonOperationInfo.tupleToStringArray(tupleKeys);
            }
            throw new RuntimeException("Key argument contains field that is neither an int nor a String: " + tupleKeys);
        }
        if (keys instanceof int[]) {
            int[] intKeys = (int[])keys;
            String[] stringKeys = new String[intKeys.length];
            for (int x = 0; x < stringKeys.length; ++x) {
                stringKeys[x] = "f0.f" + intKeys[x];
            }
            return stringKeys;
        }
        throw new RuntimeException("Key argument is neither an int[] nor a Tuple: " + keys.toString());
    }

    private static String[] tupleToStringArray(Tuple tuple) {
        String[] keys = new String[tuple.getArity()];
        for (int y = 0; y < tuple.getArity(); ++y) {
            keys[y] = (String)tuple.getField(y);
        }
        return keys;
    }

    public static enum DatasizeHint {
        NONE,
        TINY,
        HUGE;

    }
}

