/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.python.api.PythonPlanBinder;

public class PythonSender<IN>
implements Serializable {
    public static final byte TYPE_ARRAY = 63;
    public static final byte TYPE_KEY_VALUE = 62;
    public static final byte TYPE_VALUE_VALUE = 61;
    private File outputFile;
    private RandomAccessFile outputRAF;
    private FileChannel outputChannel;
    private MappedByteBuffer fileBuffer;
    private final ByteBuffer[] saved = new ByteBuffer[2];
    private final Serializer[] serializer = new Serializer[2];

    public void open(String path) throws IOException {
        this.setupMappedFile(path);
    }

    private void setupMappedFile(String outputFilePath) throws FileNotFoundException, IOException {
        File x = new File(PythonPlanBinder.FLINK_TMP_DATA_DIR);
        x.mkdirs();
        this.outputFile = new File(outputFilePath);
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        this.outputFile.createNewFile();
        this.outputRAF = new RandomAccessFile(outputFilePath, "rw");
        this.outputRAF.setLength(0x4000000L);
        this.outputRAF.seek(0x3FFFFFFL);
        this.outputRAF.writeByte(0);
        this.outputRAF.seek(0L);
        this.outputChannel = this.outputRAF.getChannel();
        this.fileBuffer = this.outputChannel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x4000000L);
    }

    public void close() throws IOException {
        this.closeMappedFile();
    }

    private void closeMappedFile() throws IOException {
        this.outputChannel.close();
        this.outputRAF.close();
    }

    public void reset() {
        this.serializer[0] = null;
        this.serializer[1] = null;
        this.fileBuffer.clear();
    }

    public int sendRecord(Object value) throws IOException {
        this.fileBuffer.clear();
        int group = 0;
        this.serializer[group] = this.getSerializer(value);
        ByteBuffer bb = this.serializer[group].serialize(value);
        if (bb.remaining() > 0x4000000) {
            throw new RuntimeException("Serialized object does not fit into a single buffer.");
        }
        this.fileBuffer.put(bb);
        int size = this.fileBuffer.position();
        this.reset();
        return size;
    }

    public boolean hasRemaining(int group) {
        return this.saved[group] != null;
    }

    public int sendBuffer(Iterator i, int group) throws IOException {
        ByteBuffer bb;
        Object value;
        this.fileBuffer.clear();
        if (this.serializer[group] == null) {
            value = i.next();
            this.serializer[group] = this.getSerializer(value);
            bb = this.serializer[group].serialize(value);
            if (bb.remaining() > 0x4000000) {
                throw new RuntimeException("Serialized object does not fit into a single buffer.");
            }
            this.fileBuffer.put(bb);
        }
        if (this.saved[group] != null) {
            this.fileBuffer.put(this.saved[group]);
            this.saved[group] = null;
        }
        while (i.hasNext() && this.saved[group] == null) {
            value = i.next();
            bb = this.serializer[group].serialize(value);
            if (bb.remaining() > 0x4000000) {
                throw new RuntimeException("Serialized object does not fit into a single buffer.");
            }
            if (bb.remaining() <= this.fileBuffer.remaining()) {
                this.fileBuffer.put(bb);
                continue;
            }
            this.saved[group] = bb;
        }
        int size = this.fileBuffer.position();
        return size;
    }

    private Serializer getSerializer(Object value) {
        if (value instanceof byte[]) {
            return new ArraySerializer();
        }
        if (((Tuple2)value).f0 instanceof byte[]) {
            return new ValuePairSerializer();
        }
        if (((Tuple2)value).f0 instanceof Tuple) {
            return new KeyValuePairSerializer();
        }
        throw new IllegalArgumentException("This object can't be serialized: " + value.toString());
    }

    private class KeyValuePairSerializer
    extends Serializer<Tuple2<Tuple, byte[]>> {
        private KeyValuePairSerializer() {
        }

        @Override
        public void serializeInternal(Tuple2<Tuple, byte[]> value) {
            int x;
            int keySize = 0;
            for (x = 0; x < ((Tuple)value.f0).getArity(); ++x) {
                keySize += ((byte[])((Tuple)value.f0).getField(x)).length;
            }
            this.buffer = ByteBuffer.allocate(5 + keySize + ((byte[])value.f1).length);
            this.buffer.put((byte)62);
            this.buffer.put((byte)((Tuple)value.f0).getArity());
            for (x = 0; x < ((Tuple)value.f0).getArity(); ++x) {
                this.buffer.put((byte[])((Tuple)value.f0).getField(x));
            }
            this.buffer.put((byte[])value.f1);
        }
    }

    private class ValuePairSerializer
    extends Serializer<Tuple2<byte[], byte[]>> {
        private ValuePairSerializer() {
        }

        @Override
        public void serializeInternal(Tuple2<byte[], byte[]> value) {
            this.buffer = ByteBuffer.allocate(1 + ((byte[])value.f0).length + ((byte[])value.f1).length);
            this.buffer.put((byte)61);
            this.buffer.put((byte[])value.f0);
            this.buffer.put((byte[])value.f1);
        }
    }

    private class ArraySerializer
    extends Serializer<byte[]> {
        private ArraySerializer() {
        }

        @Override
        public void serializeInternal(byte[] value) {
            this.buffer = ByteBuffer.allocate(value.length + 1);
            this.buffer.put((byte)63);
            this.buffer.put(value);
        }
    }

    private abstract class Serializer<T> {
        protected ByteBuffer buffer;

        private Serializer() {
        }

        public ByteBuffer serialize(T value) {
            this.serializeInternal(value);
            this.buffer.flip();
            return this.buffer;
        }

        public abstract void serializeInternal(T var1);
    }
}

