/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.functions;

import java.io.IOException;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.RichMapPartitionFunction;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.python.api.streaming.data.PythonStreamer;
import org.apache.flink.util.Collector;

public class PythonMapPartition<IN, OUT>
extends RichMapPartitionFunction<IN, OUT>
implements ResultTypeQueryable {
    private final PythonStreamer streamer;
    private final transient TypeInformation<OUT> typeInformation;

    public PythonMapPartition(int id, TypeInformation<OUT> typeInformation) {
        this.typeInformation = typeInformation;
        this.streamer = new PythonStreamer((AbstractRichFunction)this, id, typeInformation instanceof PrimitiveArrayTypeInfo);
    }

    public void open(Configuration config) throws IOException {
        this.streamer.open();
        this.streamer.sendBroadCastVariables(config);
    }

    public void mapPartition(Iterable<IN> values, Collector<OUT> out) throws Exception {
        this.streamer.streamBufferWithoutGroups(values.iterator(), out);
    }

    public void close() throws IOException {
        this.streamer.close();
    }

    public TypeInformation<OUT> getProducedType() {
        return this.typeInformation;
    }
}

