/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.ArrayList;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.fnexecution.v1.FlinkFnApi;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.PythonTypeUtils;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonTypeUtilsTest {
    PythonTypeUtilsTest() {
    }

    @Test
    void testLogicalTypetoInternalSerializer() {
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        rowFields.add(new RowType.RowField("f1", (LogicalType)new BigIntType()));
        RowType rowType = new RowType(rowFields);
        TypeSerializer baseSerializer = PythonTypeUtils.toInternalSerializer((LogicalType)rowType);
        Assertions.assertThat((Object)baseSerializer).isInstanceOf(RowDataSerializer.class);
        Assertions.assertThat((int)((RowDataSerializer)baseSerializer).getArity()).isEqualTo(1);
    }

    @Test
    void testLogicalTypeToProto() {
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        rowFields.add(new RowType.RowField("f1", (LogicalType)new BigIntType()));
        RowType rowType = new RowType(rowFields);
        FlinkFnApi.Schema.FieldType protoType = (FlinkFnApi.Schema.FieldType)rowType.accept((LogicalTypeVisitor)new PythonTypeUtils.LogicalTypeToProtoTypeConverter());
        FlinkFnApi.Schema schema = protoType.getRowSchema();
        Assertions.assertThat((int)schema.getFieldsCount()).isEqualTo(1);
        Assertions.assertThat((String)schema.getFields(0).getName()).isEqualTo("f1");
        Assertions.assertThat((Comparable)schema.getFields(0).getType().getTypeName()).isEqualTo((Object)FlinkFnApi.Schema.TypeName.BIGINT);
    }

    @Test
    void testLogicalTypeToDataConverter() {
        PythonTypeUtils.DataConverter converter = PythonTypeUtils.toDataConverter((LogicalType)new IntType());
        GenericRowData data = new GenericRowData(1);
        data.setField(0, (Object)10);
        Object externalData = converter.toExternal((RowData)data, 0);
        Assertions.assertThat((Object)externalData).isInstanceOf(Long.class);
        Assertions.assertThat((Object)externalData).isEqualTo((Object)10L);
    }

    @Test
    void testUnsupportedTypeSerializer() {
        UnresolvedUserDefinedType logicalType = new UnresolvedUserDefinedType(UnresolvedIdentifier.of((String[])new String[]{"cat", "db", "MyType"}));
        String expectedTestException = "Python UDF doesn't support logical type `cat`.`db`.`MyType` currently.";
        Assertions.assertThatThrownBy(() -> PythonTypeUtilsTest.lambda$testUnsupportedTypeSerializer$0((LogicalType)logicalType)).hasStackTraceContaining(expectedTestException);
    }

    private static /* synthetic */ void lambda$testUnsupportedTypeSerializer$0(LogicalType logicalType) throws Throwable {
        PythonTypeUtils.toInternalSerializer((LogicalType)logicalType);
    }
}

