/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.arrow;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.arrow.ArrowReader;
import org.apache.flink.table.runtime.arrow.ArrowReaderWriterTestBase;
import org.apache.flink.table.runtime.arrow.ArrowUtils;
import org.apache.flink.table.runtime.arrow.ArrowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.jupiter.api.BeforeAll;

class ArrowReaderWriterTest
extends ArrowReaderWriterTestBase<RowData> {
    private static List<LogicalType> fieldTypes = new ArrayList<LogicalType>();
    private static RowType rowType;
    private static RowType rowFieldType;
    private static BufferAllocator allocator;

    public ArrowReaderWriterTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof RowData && o2 instanceof RowData, (o1, o2, checker) -> {
            RowDataSerializer serializer = new RowDataSerializer(fieldTypes.toArray(new LogicalType[0]));
            return ArrowReaderWriterTest.deepEqualsRowData((RowData)o1, (RowData)o2, (RowDataSerializer)serializer.duplicate(), (RowDataSerializer)serializer.duplicate());
        }));
    }

    private static boolean deepEqualsRowData(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        BinaryRowData row1 = serializer1.toBinaryRow(should);
        BinaryRowData row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    @BeforeAll
    static void init() {
        fieldTypes.add((LogicalType)new TinyIntType());
        fieldTypes.add((LogicalType)new SmallIntType());
        fieldTypes.add((LogicalType)new IntType());
        fieldTypes.add((LogicalType)new BigIntType());
        fieldTypes.add((LogicalType)new BooleanType());
        fieldTypes.add((LogicalType)new FloatType());
        fieldTypes.add((LogicalType)new DoubleType());
        fieldTypes.add((LogicalType)new VarCharType());
        fieldTypes.add((LogicalType)new VarBinaryType());
        fieldTypes.add((LogicalType)new DecimalType(10, 3));
        fieldTypes.add((LogicalType)new DateType());
        fieldTypes.add((LogicalType)new TimeType(0));
        fieldTypes.add((LogicalType)new TimeType(2));
        fieldTypes.add((LogicalType)new TimeType(4));
        fieldTypes.add((LogicalType)new TimeType(8));
        fieldTypes.add((LogicalType)new LocalZonedTimestampType(0));
        fieldTypes.add((LogicalType)new LocalZonedTimestampType(2));
        fieldTypes.add((LogicalType)new LocalZonedTimestampType(4));
        fieldTypes.add((LogicalType)new LocalZonedTimestampType(8));
        fieldTypes.add((LogicalType)new TimestampType(0));
        fieldTypes.add((LogicalType)new TimestampType(2));
        fieldTypes.add((LogicalType)new TimestampType(4));
        fieldTypes.add((LogicalType)new TimestampType(8));
        fieldTypes.add((LogicalType)new ArrayType((LogicalType)new VarCharType()));
        rowFieldType = new RowType(Arrays.asList(new RowType.RowField("a", (LogicalType)new IntType()), new RowType.RowField("b", (LogicalType)new VarCharType()), new RowType.RowField("c", (LogicalType)new ArrayType((LogicalType)new VarCharType())), new RowType.RowField("d", (LogicalType)new TimestampType(2)), new RowType.RowField("e", (LogicalType)new RowType(Arrays.asList(new RowType.RowField("e1", (LogicalType)new IntType()), new RowType.RowField("e2", (LogicalType)new VarCharType()))))));
        fieldTypes.add((LogicalType)rowFieldType);
        ArrayList<RowType.RowField> rowFields = new ArrayList<RowType.RowField>();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            rowFields.add(new RowType.RowField("f" + i, fieldTypes.get(i)));
        }
        rowType = new RowType(rowFields);
        allocator = ArrowUtils.getRootAllocator().newChildAllocator("stdout", 0L, Long.MAX_VALUE);
    }

    @Override
    public ArrowReader createArrowReader(InputStream inputStream) throws IOException {
        ArrowStreamReader reader = new ArrowStreamReader(inputStream, allocator);
        reader.loadNextBatch();
        return ArrowUtils.createArrowReader((VectorSchemaRoot)reader.getVectorSchemaRoot(), (RowType)rowType);
    }

    @Override
    public Tuple2<ArrowWriter<RowData>, ArrowStreamWriter> createArrowWriter(OutputStream outputStream) throws IOException {
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)ArrowUtils.toArrowSchema((RowType)rowType), (BufferAllocator)allocator);
        ArrowWriter arrowWriter = ArrowUtils.createRowDataArrowWriter((VectorSchemaRoot)root, (RowType)rowType);
        ArrowStreamWriter arrowStreamWriter = new ArrowStreamWriter(root, null, outputStream);
        arrowStreamWriter.start();
        return Tuple2.of((Object)arrowWriter, (Object)arrowStreamWriter);
    }

    public RowData[] getTestData() {
        RowData row1 = StreamRecordUtils.row((Object[])new Object[]{(byte)1, (short)2, 3, 4L, true, Float.valueOf(1.0f), 1.0, "hello", "hello".getBytes(), DecimalData.fromUnscaledLong((long)1L, (int)10, (int)3), 100, 3600000, 3600000, 3600000, 3600000, TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L, (int)100000), new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello"), StringData.fromString((String)"\u4e2d\u6587"), null}), GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"hello"), new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello")}), TimestampData.fromEpochMillis((long)3600000L), GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"hello")})})});
        BinaryRowData row2 = StreamRecordUtils.binaryrow((Object[])new Object[]{(byte)1, (short)2, 3, 4L, false, Float.valueOf(1.0f), 1.0, "\u4e2d\u6587", "\u4e2d\u6587".getBytes(), DecimalData.fromUnscaledLong((long)1L, (int)10, (int)3), 100, 3600000, 3600000, 3600000, 3600000, Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)0), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)2), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)4), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)8), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)0), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)2), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)4), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)8), Tuple2.of((Object)new GenericArrayData((Object[])new String[]{null, null, null}), (Object)new ArrayDataSerializer((LogicalType)new VarCharType())), Tuple2.of((Object)GenericRowData.of((Object[])new Object[]{1, null, new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello")}), null, GenericRowData.of((Object[])new Object[]{1, StringData.fromString((String)"hello")})}), (Object)new RowDataSerializer(rowFieldType))});
        RowData row3 = StreamRecordUtils.row((Object[])new Object[]{null, (short)2, 3, 4L, false, Float.valueOf(1.0f), 1.0, "\u4e2d\u6587", "\u4e2d\u6587".getBytes(), DecimalData.fromUnscaledLong((long)1L, (int)10, (int)3), 100, 3600000, 3600000, 3600000, 3600000, TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L), TimestampData.fromEpochMillis((long)3600000L, (int)100000), TimestampData.fromEpochMillis((long)3600000L, (int)100000), new GenericArrayData((Object[])new String[]{null, null, null}), GenericRowData.of((Object[])new Object[]{1, null, new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello")}), null, null})});
        BinaryRowData row4 = StreamRecordUtils.binaryrow((Object[])new Object[]{(byte)1, null, 3, 4L, true, Float.valueOf(1.0f), 1.0, "hello", "hello".getBytes(), DecimalData.fromUnscaledLong((long)1L, (int)10, (int)3), 100, 3600000, 3600000, 3600000, 3600000, Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)0), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)2), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)4), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)8), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)0), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L), (Object)2), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)4), Tuple2.of((Object)TimestampData.fromEpochMillis((long)3600000L, (int)100000), (Object)8), Tuple2.of((Object)new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello"), StringData.fromString((String)"\u4e2d\u6587"), null}), (Object)new ArrayDataSerializer((LogicalType)new VarCharType())), Tuple2.of((Object)GenericRowData.of((Object[])new Object[]{1, null, new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"hello")}), null, null}), (Object)new RowDataSerializer(rowFieldType))});
        RowData row5 = StreamRecordUtils.row((Object[])new Object[fieldTypes.size()]);
        BinaryRowData row6 = StreamRecordUtils.binaryrow((Object[])new Object[fieldTypes.size()]);
        return new RowData[]{row1, row2, row3, row4, row5, row6};
    }
}

