/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.BigIntSerializer;
import org.apache.flink.api.common.typeutils.base.BooleanSerializer;
import org.apache.flink.api.common.typeutils.base.ByteSerializer;
import org.apache.flink.api.common.typeutils.base.CharSerializer;
import org.apache.flink.api.common.typeutils.base.DoubleSerializer;
import org.apache.flink.api.common.typeutils.base.FloatSerializer;
import org.apache.flink.api.common.typeutils.base.GenericArraySerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.ShortSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.api.common.typeutils.base.array.IntPrimitiveArraySerializer;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.runtime.RowSerializer;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.fnexecution.v1.FlinkFnApi;
import org.apache.flink.streaming.api.typeinfo.python.PickledByteArrayTypeInfo;
import org.apache.flink.streaming.api.utils.PythonTypeUtils;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.serializers.python.BigDecSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.DateSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.StringSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimeSerializer;
import org.apache.flink.table.runtime.typeutils.serializers.python.TimestampSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PythonTypeUtilsTest {
    PythonTypeUtilsTest() {
    }

    @Test
    void testTypeInfoToProtoConverter() {
        HashMap<Object, FlinkFnApi.TypeInfo.TypeName> typeInformationTypeNameMap = new HashMap<Object, FlinkFnApi.TypeInfo.TypeName>();
        typeInformationTypeNameMap.put(BasicTypeInfo.INT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.INT);
        typeInformationTypeNameMap.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BIG_DEC);
        typeInformationTypeNameMap.put(BasicTypeInfo.BIG_INT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BIG_INT);
        typeInformationTypeNameMap.put(BasicTypeInfo.CHAR_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.CHAR);
        typeInformationTypeNameMap.put(BasicTypeInfo.FLOAT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.FLOAT);
        typeInformationTypeNameMap.put(BasicTypeInfo.DOUBLE_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.DOUBLE);
        typeInformationTypeNameMap.put(BasicTypeInfo.SHORT_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.SHORT);
        typeInformationTypeNameMap.put(BasicTypeInfo.LONG_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.LONG);
        typeInformationTypeNameMap.put(BasicTypeInfo.STRING_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.STRING);
        typeInformationTypeNameMap.put(BasicTypeInfo.BYTE_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BYTE);
        typeInformationTypeNameMap.put(PickledByteArrayTypeInfo.PICKLED_BYTE_ARRAY_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.PICKLED_BYTES);
        typeInformationTypeNameMap.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, FlinkFnApi.TypeInfo.TypeName.BOOLEAN);
        typeInformationTypeNameMap.put(SqlTimeTypeInfo.DATE, FlinkFnApi.TypeInfo.TypeName.SQL_DATE);
        typeInformationTypeNameMap.put(SqlTimeTypeInfo.TIME, FlinkFnApi.TypeInfo.TypeName.SQL_TIME);
        typeInformationTypeNameMap.put(SqlTimeTypeInfo.TIMESTAMP, FlinkFnApi.TypeInfo.TypeName.SQL_TIMESTAMP);
        for (Map.Entry entry : typeInformationTypeNameMap.entrySet()) {
            Assertions.assertThat((Comparable)PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)((TypeInformation)entry.getKey()), null).getTypeName()).isEqualTo(entry.getValue());
        }
        PrimitiveArrayTypeInfo primitiveIntegerArrayTypeInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
        FlinkFnApi.TypeInfo convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)primitiveIntegerArrayTypeInfo, null);
        Assertions.assertThat((Comparable)convertedFieldType.getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.PRIMITIVE_ARRAY);
        Assertions.assertThat((Comparable)convertedFieldType.getCollectionElementType().getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.INT);
        BasicArrayTypeInfo basicIntegerArrayTypeInfo = BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO;
        FlinkFnApi.TypeInfo convertedBasicFieldType = PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)basicIntegerArrayTypeInfo, null);
        Assertions.assertThat((Comparable)convertedBasicFieldType.getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.BASIC_ARRAY);
        Assertions.assertThat((Comparable)convertedBasicFieldType.getCollectionElementType().getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.INT);
        TypeInformation objectArrayTypeInfo = Types.OBJECT_ARRAY((TypeInformation)Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT}));
        FlinkFnApi.TypeInfo convertedTypeInfoProto = PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)objectArrayTypeInfo, null);
        Assertions.assertThat((Comparable)convertedTypeInfoProto.getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.OBJECT_ARRAY);
        Assertions.assertThat((Comparable)convertedTypeInfoProto.getCollectionElementType().getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.ROW);
        Assertions.assertThat((Comparable)convertedTypeInfoProto.getCollectionElementType().getRowTypeInfo().getFields(0).getFieldType().getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.INT);
        TypeInformation rowTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)rowTypeInfo, null);
        Assertions.assertThat((Comparable)convertedFieldType.getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.ROW);
        Assertions.assertThat((Comparable)convertedFieldType.getRowTypeInfo().getFields(0).getFieldType().getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.INT);
        TypeInformation tupleTypeInfo = Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedFieldType = PythonTypeUtils.TypeInfoToProtoConverter.toTypeInfoProto((TypeInformation)tupleTypeInfo, null);
        Assertions.assertThat((Comparable)convertedFieldType.getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.TUPLE);
        Assertions.assertThat((Comparable)convertedFieldType.getTupleTypeInfo().getFieldTypes(0).getTypeName()).isEqualTo((Object)FlinkFnApi.TypeInfo.TypeName.INT);
    }

    @Test
    void testTypeInfoToSerializerConverter() {
        HashMap<Object, Object> typeInformationTypeSerializerMap = new HashMap<Object, Object>();
        typeInformationTypeSerializerMap.put(BasicTypeInfo.INT_TYPE_INFO, IntSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BIG_DEC_TYPE_INFO, BigDecSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BIG_INT_TYPE_INFO, BigIntSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.CHAR_TYPE_INFO, CharSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.FLOAT_TYPE_INFO, FloatSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.DOUBLE_TYPE_INFO, DoubleSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.SHORT_TYPE_INFO, ShortSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.LONG_TYPE_INFO, LongSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.STRING_TYPE_INFO, StringSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BYTE_TYPE_INFO, ByteSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(PickledByteArrayTypeInfo.PICKLED_BYTE_ARRAY_TYPE_INFO, BytePrimitiveArraySerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(BasicTypeInfo.BOOLEAN_TYPE_INFO, BooleanSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.DATE, DateSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.TIME, TimeSerializer.INSTANCE);
        typeInformationTypeSerializerMap.put(SqlTimeTypeInfo.TIMESTAMP, new TimestampSerializer(3));
        for (Map.Entry entry : typeInformationTypeSerializerMap.entrySet()) {
            Assertions.assertThat(entry.getValue()).isEqualTo((Object)PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)((TypeInformation)entry.getKey())));
        }
        PrimitiveArrayTypeInfo primitiveIntegerArrayTypeInfo = PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO;
        TypeSerializer convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)primitiveIntegerArrayTypeInfo);
        Assertions.assertThat((Object)convertedTypeSerializer).isEqualTo((Object)IntPrimitiveArraySerializer.INSTANCE);
        BasicArrayTypeInfo integerArrayTypeInfo = BasicArrayTypeInfo.INT_ARRAY_TYPE_INFO;
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)integerArrayTypeInfo);
        Assertions.assertThat((Object)convertedTypeSerializer).isEqualTo((Object)new GenericArraySerializer(Integer.class, (TypeSerializer)IntSerializer.INSTANCE));
        TypeInformation objectArrayTypeInfo = Types.OBJECT_ARRAY((TypeInformation)Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT}));
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)objectArrayTypeInfo);
        Assertions.assertThat((Object)convertedTypeSerializer).isEqualTo((Object)new GenericArraySerializer(Row.class, (TypeSerializer)new RowSerializer(new TypeSerializer[]{IntSerializer.INSTANCE}, null)));
        TypeInformation rowTypeInfo = Types.ROW((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)rowTypeInfo);
        Assertions.assertThat((Object)convertedTypeSerializer).isEqualTo((Object)new RowSerializer(new TypeSerializer[]{IntSerializer.INSTANCE}, null));
        TupleTypeInfo tupleTypeInfo = (TupleTypeInfo)Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT});
        convertedTypeSerializer = PythonTypeUtils.TypeInfoToSerializerConverter.typeInfoSerializerConverter((TypeInformation)tupleTypeInfo);
        Assertions.assertThat((Object)convertedTypeSerializer).isEqualTo((Object)new TupleSerializer(tupleTypeInfo.getTypeClass(), new TypeSerializer[]{IntSerializer.INSTANCE}));
    }

    @Test
    void testInternalTypeInfoToDataConverter() {
        RowType rowDataType = (RowType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.BOOLEAN(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.BINARY((int)10), DataTypes.VARCHAR((int)100), DataTypes.CHAR((int)100), DataTypes.VARCHAR((int)1000), DataTypes.DATE(), DataTypes.TIME(), DataTypes.ARRAY((DataType)DataTypes.STRING()), DataTypes.MAP((DataType)DataTypes.BIGINT(), (DataType)DataTypes.BYTES())}).getLogicalType();
        PythonTypeUtils.DataConverter dataConverter = PythonTypeUtils.TypeInfoToDataConverter.typeInfoDataConverter((TypeInformation)InternalTypeInfo.of((RowType)rowDataType));
        PythonTypeUtils.RowDataConverter rowDataConverter = new PythonTypeUtils.RowDataConverter(new PythonTypeUtils.DataConverter[]{PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.ByteDataConverter.INSTANCE, PythonTypeUtils.ShortDataConverter.INSTANCE, PythonTypeUtils.IntDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.FloatDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, PythonTypeUtils.IdentityDataConverter.INSTANCE, new PythonTypeUtils.ArrayDataConverter(String.class, (PythonTypeUtils.DataConverter)PythonTypeUtils.IdentityDataConverter.INSTANCE), new PythonTypeUtils.MapDataConverter((PythonTypeUtils.DataConverter)PythonTypeUtils.IdentityDataConverter.INSTANCE, (PythonTypeUtils.DataConverter)PythonTypeUtils.IdentityDataConverter.INSTANCE)});
        PythonTypeUtils.RowDataDataConverter expectedDataConverter = new PythonTypeUtils.RowDataDataConverter(rowDataConverter, DataFormatConverters.getConverterForDataType((DataType)TypeConversions.fromLogicalToDataType((LogicalType)rowDataType)));
        Assertions.assertThat((Object)dataConverter).isEqualTo((Object)expectedDataConverter);
    }
}

