/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.Service;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.service.ServiceStateException;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ServiceStateModel {
    private static final boolean[][] statemap = new boolean[][]{{false, true, false, true}, {false, true, true, true}, {false, false, true, true}, {false, false, false, true}};
    private volatile Service.STATE state;
    private String name;

    public ServiceStateModel(String name) {
        this(name, Service.STATE.NOTINITED);
    }

    public ServiceStateModel(String name, Service.STATE state) {
        this.state = state;
        this.name = name;
    }

    public Service.STATE getState() {
        return this.state;
    }

    public boolean isInState(Service.STATE proposed) {
        return this.state.equals((Object)proposed);
    }

    public void ensureCurrentState(Service.STATE expectedState) {
        if (this.state != expectedState) {
            throw new ServiceStateException(this.name + ": for this operation, the current service state must be " + (Object)((Object)expectedState) + " instead of " + (Object)((Object)this.state));
        }
    }

    public synchronized Service.STATE enterState(Service.STATE proposed) {
        ServiceStateModel.checkStateTransition(this.name, this.state, proposed);
        Service.STATE oldState = this.state;
        this.state = proposed;
        return oldState;
    }

    public static void checkStateTransition(String name, Service.STATE state, Service.STATE proposed) {
        if (!ServiceStateModel.isValidStateTransition(state, proposed)) {
            throw new ServiceStateException(name + " cannot enter state " + (Object)((Object)proposed) + " from state " + (Object)((Object)state));
        }
    }

    public static boolean isValidStateTransition(Service.STATE current, Service.STATE proposed) {
        boolean[] row = statemap[current.getValue()];
        return row[proposed.getValue()];
    }

    public String toString() {
        return (this.name.isEmpty() ? "" : this.name + ": ") + this.state.toString();
    }
}

