/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.conf.Configuration;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.BlockLocation;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.ContentSummary;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.CreateFlag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataInputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileChecksum;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FilterFileSystem;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsServerDefaults;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.FsStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.QuotaUsage;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.RemoteIterator;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.AclEntry;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.AclStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsAction;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.permission.FsPermission;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.viewfs.ViewFsFileStatus;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.security.AccessControlException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.util.Progressable;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ChRootedFileSystem
extends FilterFileSystem {
    private final URI myUri;
    private final Path chRootPathPart;
    private final String chRootPathPartString;
    private Path workingDir;
    private static Path rootPath = new Path("/");

    protected FileSystem getMyFs() {
        return this.getRawFileSystem();
    }

    protected Path fullPath(Path path) {
        super.checkPath(path);
        return path.isAbsolute() ? new Path((this.chRootPathPart.isRoot() ? "" : this.chRootPathPartString) + path.toUri().getPath()) : new Path(this.chRootPathPartString + this.workingDir.toUri().getPath(), path);
    }

    public ChRootedFileSystem(URI uri, Configuration conf) throws IOException {
        super(FileSystem.get(uri, conf));
        String pathString = uri.getPath();
        if (pathString.isEmpty()) {
            pathString = "/";
        }
        this.chRootPathPart = new Path(pathString);
        this.chRootPathPartString = this.chRootPathPart.toUri().getPath();
        this.myUri = uri;
        this.workingDir = this.getHomeDirectory();
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
    }

    @Override
    public URI getUri() {
        return this.myUri;
    }

    String stripOutRoot(Path p) throws IOException {
        try {
            this.checkPath(p);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Internal Error - path " + p + " should have been with URI: " + this.myUri);
        }
        String pathPart = p.toUri().getPath();
        return pathPart.length() == this.chRootPathPartString.length() ? "" : pathPart.substring(this.chRootPathPartString.length() + (this.chRootPathPart.isRoot() ? 0 : 1));
    }

    @Override
    protected Path getInitialWorkingDirectory() {
        return null;
    }

    public Path getResolvedQualifiedPath(Path f) throws FileNotFoundException {
        return this.makeQualified(new Path(this.chRootPathPartString + f.toUri().toString()));
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = new_dir.isAbsolute() ? new_dir : new Path(this.workingDir, new_dir);
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return super.create(this.fullPath(f), permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    @Override
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return super.createNonRecursive(this.fullPath(f), permission, flags, bufferSize, replication, blockSize, progress);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return super.delete(this.fullPath(f), recursive);
    }

    @Override
    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus fs, long start, long len) throws IOException {
        return super.getFileBlockLocations(new ViewFsFileStatus(fs, this.fullPath(fs.getPath())), start, len);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        return super.getFileChecksum(this.fullPath(f));
    }

    @Override
    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return super.getFileChecksum(this.fullPath(f), length);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return super.getFileStatus(this.fullPath(f));
    }

    @Override
    public Path getLinkTarget(Path f) throws IOException {
        return super.getLinkTarget(this.fullPath(f));
    }

    @Override
    public void access(Path path, FsAction mode) throws AccessControlException, FileNotFoundException, IOException {
        super.access(this.fullPath(path), mode);
    }

    @Override
    public FsStatus getStatus(Path p) throws IOException {
        return super.getStatus(this.fullPath(p));
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        return super.listStatus(this.fullPath(f));
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return super.listLocatedStatus(this.fullPath(f));
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return super.mkdirs(this.fullPath(f), permission);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return super.open(this.fullPath(f), bufferSize);
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return super.append(this.fullPath(f), bufferSize, progress);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return super.rename(this.fullPath(src), this.fullPath(dst));
    }

    @Override
    public void setOwner(Path f, String username, String groupname) throws IOException {
        super.setOwner(this.fullPath(f), username, groupname);
    }

    @Override
    public void setPermission(Path f, FsPermission permission) throws IOException {
        super.setPermission(this.fullPath(f), permission);
    }

    @Override
    public boolean setReplication(Path f, short replication) throws IOException {
        return super.setReplication(this.fullPath(f), replication);
    }

    @Override
    public void setTimes(Path f, long mtime, long atime) throws IOException {
        super.setTimes(this.fullPath(f), mtime, atime);
    }

    @Override
    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        super.modifyAclEntries(this.fullPath(path), aclSpec);
    }

    @Override
    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        super.removeAclEntries(this.fullPath(path), aclSpec);
    }

    @Override
    public void removeDefaultAcl(Path path) throws IOException {
        super.removeDefaultAcl(this.fullPath(path));
    }

    @Override
    public void removeAcl(Path path) throws IOException {
        super.removeAcl(this.fullPath(path));
    }

    @Override
    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        super.setAcl(this.fullPath(path), aclSpec);
    }

    @Override
    public AclStatus getAclStatus(Path path) throws IOException {
        return super.getAclStatus(this.fullPath(path));
    }

    @Override
    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        super.setXAttr(this.fullPath(path), name, value, flag);
    }

    @Override
    public byte[] getXAttr(Path path, String name) throws IOException {
        return super.getXAttr(this.fullPath(path), name);
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return super.getXAttrs(this.fullPath(path));
    }

    @Override
    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return super.getXAttrs(this.fullPath(path), names);
    }

    @Override
    public boolean truncate(Path path, long newLength) throws IOException {
        return super.truncate(this.fullPath(path), newLength);
    }

    @Override
    public List<String> listXAttrs(Path path) throws IOException {
        return super.listXAttrs(this.fullPath(path));
    }

    @Override
    public void removeXAttr(Path path, String name) throws IOException {
        super.removeXAttr(this.fullPath(path), name);
    }

    @Override
    public Path createSnapshot(Path path, String name) throws IOException {
        return super.createSnapshot(this.fullPath(path), name);
    }

    @Override
    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        super.renameSnapshot(this.fullPath(path), snapshotOldName, snapshotNewName);
    }

    @Override
    public void deleteSnapshot(Path snapshotDir, String snapshotName) throws IOException {
        super.deleteSnapshot(this.fullPath(snapshotDir), snapshotName);
    }

    @Override
    public Path resolvePath(Path p) throws IOException {
        return super.resolvePath(this.fullPath(p));
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.fs.getContentSummary(this.fullPath(f));
    }

    @Override
    public QuotaUsage getQuotaUsage(Path f) throws IOException {
        return this.fs.getQuotaUsage(this.fullPath(f));
    }

    @Override
    public long getDefaultBlockSize() {
        return this.getDefaultBlockSize(this.fullPath(rootPath));
    }

    @Override
    public long getDefaultBlockSize(Path f) {
        return super.getDefaultBlockSize(this.fullPath(f));
    }

    @Override
    public short getDefaultReplication() {
        return this.getDefaultReplication(this.fullPath(rootPath));
    }

    @Override
    public short getDefaultReplication(Path f) {
        return super.getDefaultReplication(this.fullPath(f));
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        return this.getServerDefaults(this.fullPath(rootPath));
    }

    @Override
    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return super.getServerDefaults(this.fullPath(f));
    }

    @Override
    public BlockStoragePolicySpi getStoragePolicy(Path src) throws IOException {
        return super.getStoragePolicy(this.fullPath(src));
    }

    @Override
    public void setStoragePolicy(Path src, String policyName) throws IOException {
        super.setStoragePolicy(this.fullPath(src), policyName);
    }

    @Override
    public void unsetStoragePolicy(Path src) throws IOException {
        super.unsetStoragePolicy(this.fullPath(src));
    }
}

