/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.OSSObjectSummary;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.Path;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss.AliyunOSSUtils;

public interface FileStatusAcceptor {
    public boolean accept(Path var1, OSSObjectSummary var2);

    public boolean accept(Path var1, String var2);

    public static class AcceptAllButSelf
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptAllButSelf(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, OSSObjectSummary summary) {
            return !keyPath.equals(this.qualifiedPath);
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return !keyPath.equals(this.qualifiedPath);
        }
    }

    public static class AcceptFilesOnly
    implements FileStatusAcceptor {
        private final Path qualifiedPath;

        public AcceptFilesOnly(Path qualifiedPath) {
            this.qualifiedPath = qualifiedPath;
        }

        @Override
        public boolean accept(Path keyPath, OSSObjectSummary summary) {
            return !keyPath.equals(this.qualifiedPath) && !AliyunOSSUtils.objectRepresentsDirectory(summary.getKey(), summary.getSize());
        }

        @Override
        public boolean accept(Path keyPath, String prefix) {
            return false;
        }
    }
}

