/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss;

import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss.AliyunOSSCopyFileContext;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs.aliyun.oss.AliyunOSSFileSystemStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOSSCopyFileTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(AliyunOSSCopyFileTask.class);
    private AliyunOSSFileSystemStore store;
    private String srcKey;
    private String dstKey;
    private AliyunOSSCopyFileContext copyFileContext;

    public AliyunOSSCopyFileTask(AliyunOSSFileSystemStore store, String srcKey, String dstKey, AliyunOSSCopyFileContext copyFileContext) {
        this.store = store;
        this.srcKey = srcKey;
        this.dstKey = dstKey;
        this.copyFileContext = copyFileContext;
    }

    @Override
    public void run() {
        boolean fail = false;
        try {
            this.store.copyFile(this.srcKey, this.dstKey);
        }
        catch (Exception e) {
            LOG.warn("Exception thrown when copy from " + this.srcKey + " to " + this.dstKey + ", exception: " + e);
            fail = true;
        }
        finally {
            this.copyFileContext.lock();
            if (fail) {
                this.copyFileContext.setCopyFailure(fail);
            }
            this.copyFileContext.incCopiesFinish();
            this.copyFileContext.signalAll();
            this.copyFileContext.unlock();
        }
    }
}

