/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth;

import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.DefaultAcsClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.IAcsClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.BasicSessionCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.KeyPairCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.GetSessionAccessKeyRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.sts.GetSessionAccessKeyResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ServerException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.ProtocolType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.profile.IClientProfile;

public class STSGetSessionAccessKeyCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final IAcsClient stsClient;
    private final KeyPairCredentials keyPairCredentials;
    private long sessionDurationSeconds = 3600L;
    private BasicSessionCredentials sessionCredentials = null;

    public STSGetSessionAccessKeyCredentialsProvider(KeyPairCredentials keyPairCredentials, IClientProfile profile) {
        this.keyPairCredentials = keyPairCredentials;
        this.stsClient = new DefaultAcsClient(profile, keyPairCredentials);
    }

    public STSGetSessionAccessKeyCredentialsProvider withDurationSeconds(long seconds) {
        this.sessionDurationSeconds = seconds;
        return this;
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.sessionCredentials == null || this.sessionCredentials.willSoonExpire()) {
            this.sessionCredentials = this.getNewSessionCredentials();
        }
        return this.sessionCredentials;
    }

    private BasicSessionCredentials getNewSessionCredentials() throws ClientException, ServerException {
        GetSessionAccessKeyRequest request = new GetSessionAccessKeyRequest();
        request.setPublicKeyId(this.keyPairCredentials.getAccessKeyId());
        request.setDurationSeconds((int)this.sessionDurationSeconds);
        request.setProtocol(ProtocolType.HTTPS);
        GetSessionAccessKeyResponse response = this.stsClient.getAcsResponse(request);
        return new BasicSessionCredentials(response.getSessionAccesskey().getSessionAccessKeyId(), response.getSessionAccesskey().getSessionAccessKeySecert(), null, this.sessionDurationSeconds);
    }
}

