/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AcsURLEncoder;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.ISignatureComposer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Signer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.FormatType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.MethodType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.utils.ParameterHelper;

public class RpcSignatureComposer
implements ISignatureComposer {
    private static ISignatureComposer composer = null;
    private static final String SEPARATOR = "&";

    private RpcSignatureComposer() {
    }

    @Override
    public Map<String, String> refreshSignParameters(Map<String, String> parameters, Signer signer, String accessKeyId, FormatType format) {
        HashMap<String, String> immutableMap = new HashMap<String, String>(parameters);
        immutableMap.put("Timestamp", ParameterHelper.getISO8601Time(null));
        immutableMap.put("SignatureMethod", signer.getSignerName());
        immutableMap.put("SignatureVersion", signer.getSignerVersion());
        immutableMap.put("SignatureNonce", ParameterHelper.getUniqueNonce());
        immutableMap.put("AccessKeyId", accessKeyId);
        if (null != format) {
            immutableMap.put("Format", format.toString());
        }
        if (signer.getSignerType() != null) {
            immutableMap.put("SignatureType", signer.getSignerType());
        }
        return immutableMap;
    }

    @Override
    public String composeStringToSign(MethodType method, String uriPattern, Signer signer, Map<String, String> queries, Map<String, String> headers, Map<String, String> paths) {
        Object[] sortedKeys = queries.keySet().toArray(new String[0]);
        Arrays.sort(sortedKeys);
        StringBuilder canonicalizedQueryString = new StringBuilder();
        try {
            for (Object key : sortedKeys) {
                canonicalizedQueryString.append(SEPARATOR).append(AcsURLEncoder.percentEncode((String)key)).append("=").append(AcsURLEncoder.percentEncode(queries.get(key)));
            }
            StringBuilder stringToSign = new StringBuilder();
            stringToSign.append(method.toString());
            stringToSign.append(SEPARATOR);
            stringToSign.append(AcsURLEncoder.percentEncode("/"));
            stringToSign.append(SEPARATOR);
            stringToSign.append(AcsURLEncoder.percentEncode(canonicalizedQueryString.toString().substring(1)));
            return stringToSign.toString();
        }
        catch (UnsupportedEncodingException exp) {
            throw new RuntimeException("UTF-8 encoding is not supported.");
        }
    }

    public static ISignatureComposer getComposer() {
        if (null == composer) {
            composer = new RpcSignatureComposer();
        }
        return composer;
    }
}

