/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyuncs;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.AcsRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.AcsResponse;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.BasicSessionCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.KeyPairCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.RpcSignatureComposer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.auth.Signer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.FormatType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.MethodType;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.regions.ProductDomain;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.utils.ParameterHelper;

public abstract class RpcAcsRequest<T extends AcsResponse>
extends AcsRequest<T> {
    public RpcAcsRequest(String product) {
        super(product);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version) {
        super(product);
        this.setVersion(version);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action) {
        super(product);
        this.setVersion(version);
        this.setActionName(action);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct) {
        super(product);
        this.setVersion(version);
        this.setActionName(action);
        this.setLocationProduct(locationProduct);
        this.initialize();
    }

    public RpcAcsRequest(String product, String version, String action, String locationProduct, String endpointType) {
        super(product);
        this.setVersion(version);
        this.setActionName(action);
        this.setLocationProduct(locationProduct);
        this.setEndpointType(endpointType);
        this.initialize();
    }

    private void initialize() {
        this.setMethod(MethodType.GET);
        this.setAcceptFormat(FormatType.XML);
        this.composer = RpcSignatureComposer.getComposer();
    }

    @Override
    public void setActionName(String actionName) {
        super.setActionName(actionName);
        this.putQueryParameter("Action", actionName);
    }

    @Override
    public void setVersion(String version) {
        super.setVersion(version);
        this.putQueryParameter("Version", version);
    }

    @Override
    public void setSecurityToken(String securityToken) {
        super.setSecurityToken(securityToken);
        this.putQueryParameter("SecurityToken", securityToken);
    }

    @Override
    public void setAcceptFormat(FormatType acceptFormat) {
        super.setAcceptFormat(acceptFormat);
        this.putQueryParameter("Format", acceptFormat.toString());
    }

    @Override
    public String composeUrl(String endpoint, Map<String, String> queries) throws UnsupportedEncodingException {
        Map<String, String> mapQueries = queries == null ? this.getQueryParameters() : queries;
        StringBuilder urlBuilder = new StringBuilder("");
        urlBuilder.append(this.getProtocol().toString());
        urlBuilder.append("://").append(endpoint);
        if (-1 == urlBuilder.indexOf("?")) {
            urlBuilder.append("/?");
        }
        String query = RpcAcsRequest.concatQueryString(mapQueries);
        return urlBuilder.append(query).toString();
    }

    @Override
    public HttpRequest signRequest(Signer signer, AlibabaCloudCredentials credentials, FormatType format, ProductDomain domain) throws InvalidKeyException, IllegalStateException, UnsupportedEncodingException {
        Map<String, String> imutableMap = new HashMap<String, String>(this.getQueryParameters());
        if (null != signer && null != credentials) {
            String sessionToken;
            String accessKeyId = credentials.getAccessKeyId();
            String accessSecret = credentials.getAccessKeySecret();
            if (credentials instanceof BasicSessionCredentials && null != (sessionToken = ((BasicSessionCredentials)credentials).getSessionToken())) {
                this.putQueryParameter("SecurityToken", sessionToken);
            }
            imutableMap = this.composer.refreshSignParameters(this.getQueryParameters(), signer, accessKeyId, format);
            imutableMap.put("RegionId", this.getRegionId());
            HashMap<String, String> paramsToSign = new HashMap<String, String>(imutableMap);
            Map<String, String> formParams = this.getBodyParameters();
            if (formParams != null && !formParams.isEmpty()) {
                byte[] data = ParameterHelper.getFormData(formParams);
                this.setHttpContent(data, "UTF-8", FormatType.FORM);
                paramsToSign.putAll(formParams);
            }
            String strToSign = this.composer.composeStringToSign(this.getMethod(), null, signer, paramsToSign, null, null);
            String signature = credentials instanceof KeyPairCredentials ? signer.signString(strToSign, credentials) : signer.signString(strToSign, accessSecret + "&");
            imutableMap.put("Signature", signature);
        }
        this.setUrl(this.composeUrl(domain.getDomianName(), imutableMap));
        return this;
    }
}

