/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientConfiguration;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.HttpMethod;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.HmacSHA256Signature;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.CodingUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.HttpUtil;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GeneratePresignedUrlRequest;

public class SignV2Utils {
    public static String composeRequestAuthorization(String accessKeyId, String signature, RequestMessage request) {
        StringBuilder sb = new StringBuilder();
        sb.append("OSS2 AccessKeyId").append(":").append(accessKeyId).append(", ");
        String additionHeaderNameStr = SignV2Utils.buildSortedAdditionalHeaderNameStr(request.getOriginalRequest().getHeaders().keySet(), request.getOriginalRequest().getAdditionalHeaderNames());
        if (!additionHeaderNameStr.isEmpty()) {
            sb.append("AdditionalHeaders").append(":").append(additionHeaderNameStr).append(", ");
        }
        sb.append("Signature").append(":").append(signature);
        return sb.toString();
    }

    private static String buildSortedAdditionalHeaderNameStr(Set<String> headerNames, Set<String> additionalHeaderNames) {
        Set<String> ts = SignV2Utils.buildSortedAdditionalHeaderNames(headerNames, additionalHeaderNames);
        StringBuilder sb = new StringBuilder();
        String separator = "";
        for (String header : ts) {
            sb.append(separator);
            sb.append(header);
            separator = ";";
        }
        return sb.toString();
    }

    private static Set<String> buildSortedAdditionalHeaderNames(Set<String> headerNames, Set<String> additionalHeaderNames) {
        TreeSet<String> ts = new TreeSet<String>();
        if (headerNames != null && additionalHeaderNames != null) {
            for (String additionalHeaderName : additionalHeaderNames) {
                if (!headerNames.contains(additionalHeaderName)) continue;
                ts.add(additionalHeaderName.toLowerCase());
            }
        }
        return ts;
    }

    private static Set<String> buildRawAdditionalHeaderNames(Set<String> headerNames, Set<String> additionalHeaderNames) {
        HashSet<String> hs = new HashSet<String>();
        if (headerNames != null && additionalHeaderNames != null) {
            for (String additionalHeaderName : additionalHeaderNames) {
                if (!headerNames.contains(additionalHeaderName)) continue;
                hs.add(additionalHeaderName);
            }
        }
        return hs;
    }

    /*
     * WARNING - void declaration
     */
    public static String buildCanonicalString(String method, String resourcePath, RequestMessage request, Set<String> additionalHeaderNames) {
        StringBuilder canonicalString = new StringBuilder();
        canonicalString.append(method).append("\n");
        Map<String, String> headers = request.getHeaders();
        TreeMap<String, String> fixedHeadersToSign = new TreeMap<String, String>();
        TreeMap<String, String> canonicalizedOssHeadersToSign = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                if (entry.getKey() == null) continue;
                String lowerKey = entry.getKey().toLowerCase();
                if (lowerKey.equals("Content-Type".toLowerCase()) || lowerKey.equals("Content-MD5".toLowerCase()) || lowerKey.equals("Date".toLowerCase())) {
                    fixedHeadersToSign.put(lowerKey, entry.getValue().trim());
                    continue;
                }
                if (!lowerKey.startsWith("x-oss-")) continue;
                canonicalizedOssHeadersToSign.put(lowerKey, entry.getValue().trim());
            }
        }
        if (!fixedHeadersToSign.containsKey("Content-Type".toLowerCase())) {
            fixedHeadersToSign.put("Content-Type".toLowerCase(), "");
        }
        if (!fixedHeadersToSign.containsKey("Content-MD5".toLowerCase())) {
            fixedHeadersToSign.put("Content-MD5".toLowerCase(), "");
        }
        for (String string : additionalHeaderNames) {
            if (string == null || headers.get(string) == null) continue;
            canonicalizedOssHeadersToSign.put(string.toLowerCase(), headers.get(string).trim());
        }
        for (Map.Entry entry : fixedHeadersToSign.entrySet()) {
            Object value = entry.getValue();
            canonicalString.append(value);
            canonicalString.append("\n");
        }
        for (Map.Entry entry : canonicalizedOssHeadersToSign.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            canonicalString.append(key).append(':').append(value).append("\n");
        }
        TreeSet<String> ts = new TreeSet<String>();
        for (String additionalHeaderName : additionalHeaderNames) {
            ts.add(additionalHeaderName.toLowerCase());
        }
        String string = "";
        for (String additionalHeaderName : ts) {
            void var9_18;
            canonicalString.append((String)var9_18).append(additionalHeaderName);
            String string2 = ";";
        }
        canonicalString.append("\n");
        canonicalString.append(SignV2Utils.buildCanonicalizedResource(resourcePath, request.getParameters()));
        return canonicalString.toString();
    }

    public static String buildSignedURL(GeneratePresignedUrlRequest request, Credentials currentCreds, ClientConfiguration config, URI endpoint) {
        String bucketName = request.getBucketName();
        String accessId = currentCreds.getAccessKeyId();
        String accessKey = currentCreds.getSecretAccessKey();
        boolean useSecurityToken = currentCreds.useSecurityToken();
        HttpMethod method = request.getMethod() != null ? request.getMethod() : HttpMethod.GET;
        String expires = String.valueOf(request.getExpiration().getTime() / 1000L);
        String key = request.getKey();
        String resourcePath = OSSUtils.determineResourcePath(bucketName, key, config.isSLDEnabled());
        RequestMessage requestMessage = new RequestMessage(bucketName, key);
        requestMessage.setEndpoint(OSSUtils.determineFinalEndpoint(endpoint, bucketName, config));
        requestMessage.setMethod(method);
        requestMessage.setResourcePath(resourcePath);
        requestMessage.setHeaders(request.getHeaders());
        requestMessage.addHeader("Date", expires);
        if (request.getContentType() != null && !request.getContentType().trim().equals("")) {
            requestMessage.addHeader("Content-Type", request.getContentType());
        }
        if (request.getContentMD5() != null && !request.getContentMD5().trim().equals("")) {
            requestMessage.addHeader("Content-MD5", request.getContentMD5());
        }
        for (Map.Entry<String, String> h : request.getUserMetadata().entrySet()) {
            requestMessage.addHeader("x-oss-meta-" + h.getKey(), h.getValue());
        }
        HashMap<String, String> responseHeaderParams = new HashMap<String, String>();
        OSSUtils.populateResponseHeaderParameters(responseHeaderParams, request.getResponseHeaders());
        if (responseHeaderParams.size() > 0) {
            requestMessage.setParameters(responseHeaderParams);
        }
        if (request.getQueryParameter() != null && request.getQueryParameter().size() > 0) {
            for (Map.Entry<String, String> entry : request.getQueryParameter().entrySet()) {
                requestMessage.addParameter(entry.getKey(), entry.getValue());
            }
        }
        if (request.getProcess() != null && !request.getProcess().trim().equals("")) {
            requestMessage.addParameter("x-oss-process", request.getProcess());
        }
        if (useSecurityToken) {
            requestMessage.addParameter("security-token", currentCreds.getSecurityToken());
        }
        String canonicalResource = "/" + (bucketName != null ? bucketName : "") + (key != null ? "/" + key : "");
        requestMessage.addParameter("x-oss-signature-version", "OSS2");
        requestMessage.addParameter("x-oss-expires", expires);
        requestMessage.addParameter("x-oss-access-key-id", accessId);
        String additionalHeaderNameStr = SignV2Utils.buildSortedAdditionalHeaderNameStr(requestMessage.getHeaders().keySet(), request.getAdditionalHeaderNames());
        if (!additionalHeaderNameStr.isEmpty()) {
            requestMessage.addParameter("x-oss-additional-headers", additionalHeaderNameStr);
        }
        Set<String> rawAdditionalHeaderNames = SignV2Utils.buildRawAdditionalHeaderNames(request.getHeaders().keySet(), request.getAdditionalHeaderNames());
        String canonicalString = SignV2Utils.buildCanonicalString(method.toString(), canonicalResource, requestMessage, rawAdditionalHeaderNames);
        String signature = new HmacSHA256Signature().computeSignature(accessKey, canonicalString);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        if (!additionalHeaderNameStr.isEmpty()) {
            params.put("x-oss-additional-headers", additionalHeaderNameStr);
        }
        params.put("x-oss-signature", signature);
        params.putAll(requestMessage.getParameters());
        String queryString = HttpUtil.paramToQueryString(params, "utf-8");
        String url = requestMessage.getEndpoint().toString();
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        url = url + resourcePath + "?" + queryString;
        return url;
    }

    private static String buildCanonicalizedResource(String resourcePath, Map<String, String> parameters) {
        CodingUtils.assertTrue(resourcePath.startsWith("/"), "Resource path should start with slash character");
        StringBuilder builder = new StringBuilder();
        builder.append(SignV2Utils.uriEncoding(resourcePath));
        if (parameters != null) {
            Object[] parameterNames = parameters.keySet().toArray(new String[parameters.size()]);
            Arrays.sort(parameterNames);
            int separator = 63;
            for (Object paramName : parameterNames) {
                builder.append((char)separator);
                builder.append(SignV2Utils.uriEncoding((String)paramName));
                String paramValue = parameters.get(paramName);
                if (paramValue != null && !paramValue.isEmpty()) {
                    builder.append("=").append(SignV2Utils.uriEncoding(paramValue));
                }
                separator = 38;
            }
        }
        return builder.toString();
    }

    public static String uriEncoding(String uri) {
        String result = "";
        try {
            for (char c : uri.toCharArray()) {
                if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '~' || c == '.') {
                    result = result + c;
                    continue;
                }
                if (c == '/') {
                    result = result + "%2F";
                    continue;
                }
                byte[] b = Character.toString(c).getBytes("utf-8");
                for (int i = 0; i < b.length; ++i) {
                    int k = b[i];
                    if (k < 0) {
                        k += 256;
                    }
                    result = result + "%" + Integer.toHexString(k).toUpperCase();
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(e);
        }
        return result;
    }

    public static String buildSignature(String secretAccessKey, String httpMethod, String resourcePath, RequestMessage request) {
        String canonicalString = SignV2Utils.buildCanonicalString(httpMethod, resourcePath, request, SignV2Utils.buildRawAdditionalHeaderNames(request.getOriginalRequest().getHeaders().keySet(), request.getOriginalRequest().getAdditionalHeaderNames()));
        return new HmacSHA256Signature().computeSignature(secretAccessKey, canonicalString);
    }
}

