/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ServiceException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.JAXBResponseParser;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParseException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.ExceptionFactory;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSCallbackErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws ServiceException, ClientException {
        if (response.getStatusCode() == 203) {
            JAXBResponseParser parser = new JAXBResponseParser(OSSErrorResult.class);
            try {
                try {
                    OSSErrorResult errorResult = (OSSErrorResult)parser.parse(response);
                    throw ExceptionFactory.createOSSException(errorResult, response.getErrorResponseAsString());
                }
                catch (ResponseParseException e) {
                    throw ExceptionFactory.createInvalidResponseException(response.getRequestId(), response.getErrorResponseAsString(), e);
                }
            }
            catch (Throwable throwable) {
                OSSUtils.safeCloseResponse(response);
                throw throwable;
            }
        }
    }
}

