/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;

public class ChunkedUploadStream
extends InputStream {
    private static final int DEFAULT_CHUNK_SIZE = 131072;
    private static final String DEFAULT_CHARTSET_NAME = "utf-8";
    private static final String CLRF = "\r\n";
    private InputStream innerStream;
    private byte[] inputBuffer;
    private byte[] outputBuffer;
    private int outputBufferPos = -1;
    private int outputBufferDataLen = -1;
    private final int innerStreamBufferSize;
    private boolean innerStreamConsumed = false;
    private boolean isTerminatingChunk = false;

    public ChunkedUploadStream(InputStream innerStream, int innerStreamBufferSize) {
        if (innerStream == null) {
            throw new IllegalArgumentException("Source input stream should not be null");
        }
        this.innerStream = innerStream;
        this.innerStreamBufferSize = innerStreamBufferSize;
        this.inputBuffer = new byte[131072];
        this.outputBuffer = new byte[ChunkedUploadStream.CalculateChunkHeaderLength(131072L)];
    }

    @Override
    public int read() throws IOException {
        byte[] tmp = new byte[1];
        int count = this.read(tmp);
        if (count != -1) {
            return tmp[0];
        }
        return count;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || count < 0 || count > buffer.length - offset) {
            throw new IndexOutOfBoundsException(String.format("buffer size: %n, offset: %n, count: %n", buffer.length, offset, count));
        }
        if (count == 0) {
            return 0;
        }
        if (this.outputBufferPos == -1) {
            if (this.innerStreamConsumed && this.isTerminatingChunk) {
                return -1;
            }
            int bytesRead = this.fillInputBuffer();
            this.constructOutputBufferChunk(bytesRead);
            this.isTerminatingChunk = this.innerStreamConsumed && bytesRead == 0;
        }
        int outputRemaining = this.outputBufferDataLen - this.outputBufferPos;
        int bytesToRead = count;
        if (outputRemaining < count) {
            bytesToRead = outputRemaining;
        }
        System.arraycopy(this.outputBuffer, this.outputBufferPos, buffer, 0, bytesToRead);
        this.outputBufferPos += bytesToRead;
        if (this.outputBufferPos >= this.outputBufferDataLen) {
            this.outputBufferPos = -1;
        }
        return bytesToRead;
    }

    private int fillInputBuffer() {
        if (this.innerStreamConsumed) {
            return 0;
        }
        int inputBufferPos = 0;
        while (inputBufferPos < this.inputBuffer.length && !this.innerStreamConsumed) {
            int chunkBufferRemaining = this.inputBuffer.length - inputBufferPos;
            if (chunkBufferRemaining > this.innerStreamBufferSize) {
                chunkBufferRemaining = this.innerStreamBufferSize;
            }
            int bytesRead = 0;
            try {
                bytesRead = this.innerStream.read(this.inputBuffer, inputBufferPos, chunkBufferRemaining);
                if (bytesRead == -1) {
                    this.innerStreamConsumed = true;
                    continue;
                }
                inputBufferPos += bytesRead;
            }
            catch (IOException e) {
                throw new ClientException("Unexpected IO exception, " + e.getMessage(), e);
            }
        }
        return inputBufferPos;
    }

    private void constructOutputBufferChunk(int dataLen) {
        StringBuilder chunkHeader = new StringBuilder();
        chunkHeader.append(Integer.toHexString(dataLen));
        chunkHeader.append(CLRF);
        try {
            byte[] header = chunkHeader.toString().getBytes(DEFAULT_CHARTSET_NAME);
            byte[] trailer = CLRF.getBytes(DEFAULT_CHARTSET_NAME);
            int writePos = 0;
            System.arraycopy(header, 0, this.outputBuffer, writePos, header.length);
            writePos += header.length;
            if (dataLen > 0) {
                System.arraycopy(this.inputBuffer, 0, this.outputBuffer, writePos, dataLen);
                writePos += dataLen;
            }
            System.arraycopy(trailer, 0, this.outputBuffer, writePos, trailer.length);
            this.outputBufferPos = 0;
            this.outputBufferDataLen = header.length + dataLen + trailer.length;
        }
        catch (Exception e) {
            throw new ClientException("Unable to sign the chunked data, " + e.getMessage(), e);
        }
    }

    private static int CalculateChunkHeaderLength(long chunkDataSize) {
        return (int)((long)(Long.toHexString(chunkDataSize).length() + CLRF.length()) + chunkDataSize + (long)CLRF.length());
    }
}

