/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.OSSException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.RequestMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressListener;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.event.ProgressPublisher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.WebServiceRequest;

public class RequestProgressHanlder
implements RequestHandler {
    @Override
    public void handle(RequestMessage request) throws OSSException, ClientException {
        InputStream content;
        WebServiceRequest originalRequest = request.getOriginalRequest();
        ProgressListener listener = originalRequest.getProgressListener();
        Map<String, String> headers = request.getHeaders();
        String s = headers.get("Content-Length");
        if (s != null) {
            try {
                long contentLength = Long.parseLong(s);
                ProgressPublisher.publishRequestContentLength(listener, contentLength);
            }
            catch (NumberFormatException e) {
                LogUtils.logException("Cannot parse the Content-Length header of the request: ", e);
            }
        }
        if ((content = request.getContent()) == null) {
            return;
        }
        if (!content.markSupported()) {
            content = new BufferedInputStream(content);
        }
        request.setContent(listener == ProgressListener.NOOP ? content : ProgressInputStream.inputStreamForRequest(content, originalRequest));
    }
}

