/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.RefreshHandler;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.RefreshResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Unstable
public class RefreshRegistry {
    public static final Logger LOG = LoggerFactory.getLogger(RefreshRegistry.class);
    private final Multimap<String, RefreshHandler> handlerTable = HashMultimap.create();

    public static RefreshRegistry defaultRegistry() {
        return RegistryHolder.registry;
    }

    public synchronized void register(String identifier, RefreshHandler handler) {
        if (identifier == null) {
            throw new NullPointerException("Identifier cannot be null");
        }
        this.handlerTable.put(identifier, handler);
    }

    public synchronized boolean unregister(String identifier, RefreshHandler handler) {
        return this.handlerTable.remove(identifier, handler);
    }

    public synchronized void unregisterAll(String identifier) {
        this.handlerTable.removeAll(identifier);
    }

    public synchronized Collection<RefreshResponse> dispatch(String identifier, String[] args) {
        Collection<RefreshHandler> handlers = this.handlerTable.get(identifier);
        if (handlers.size() == 0) {
            String msg = "Identifier '" + identifier + "' does not exist in RefreshRegistry. Valid options are: " + Joiner.on(", ").join(this.handlerTable.keySet());
            throw new IllegalArgumentException(msg);
        }
        ArrayList<RefreshResponse> responses = new ArrayList<RefreshResponse>(handlers.size());
        for (RefreshHandler handler : handlers) {
            RefreshResponse response;
            try {
                response = handler.handleRefresh(identifier, args);
                if (response == null) {
                    throw new NullPointerException("Handler returned null.");
                }
                LOG.info(this.handlerName(handler) + " responds to '" + identifier + "', says: '" + response.getMessage() + "', returns " + response.getReturnCode());
            }
            catch (Exception e) {
                response = new RefreshResponse(-1, e.getLocalizedMessage());
            }
            response.setSenderName(this.handlerName(handler));
            responses.add(response);
        }
        return responses;
    }

    private String handlerName(RefreshHandler h) {
        return h.getClass().getName() + '@' + Integer.toHexString(h.hashCode());
    }

    private static class RegistryHolder {
        public static RefreshRegistry registry = new RefreshRegistry();

        private RegistryHolder() {
        }
    }
}

