/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.OSSException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseHandler;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.JAXBResponseParser;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParseException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.ExceptionFactory;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.model.OSSErrorResult;

public class OSSErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws OSSException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createOSSException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createOSSException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createOSSException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            throw ExceptionFactory.createUnknownOSSException(requestId, statusCode);
        }
        JAXBResponseParser parser = new JAXBResponseParser(OSSErrorResult.class);
        try {
            try {
                OSSErrorResult errorResult = (OSSErrorResult)parser.parse(response);
                throw ExceptionFactory.createOSSException(errorResult, response.getErrorResponseAsString());
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, response.getErrorResponseAsString(), e);
            }
        }
        catch (Throwable throwable) {
            OSSUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

