/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import java.io.UnsupportedEncodingException;
import javax.crypto.Mac;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.ServiceSignature;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.BinaryUtil;

public class HmacSHA256Signature
extends ServiceSignature {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ALGORITHM = "HmacSHA256";
    private static final String VERSION = "1";
    private static final Object LOCK = new Object();
    private static Mac macInstance;

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public String computeSignature(String key, String data) {
        try {
            byte[] signData = this.sign(key.getBytes(DEFAULT_ENCODING), data.getBytes(DEFAULT_ENCODING), macInstance, LOCK, ALGORITHM);
            return BinaryUtil.toBase64String(signData);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unsupported algorithm: UTF-8", ex);
        }
    }
}

