/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry;

import java.lang.reflect.Method;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryInvocationHandler;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.ipc.RetriableException;

@InterfaceAudience.Private
public class LossyRetryInvocationHandler<T>
extends RetryInvocationHandler<T> {
    private final int numToDrop;
    private static final ThreadLocal<Integer> RetryCount = new ThreadLocal();

    public LossyRetryInvocationHandler(int numToDrop, FailoverProxyProvider<T> proxyProvider, RetryPolicy retryPolicy) {
        super(proxyProvider, retryPolicy);
        this.numToDrop = numToDrop;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryCount.set(0);
        return super.invoke(proxy, method, args);
    }

    @Override
    protected Object invokeMethod(Method method, Object[] args) throws Throwable {
        Object result = super.invokeMethod(method, args);
        int retryCount = RetryCount.get();
        if (retryCount < this.numToDrop) {
            RetryCount.set(++retryCount);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Drop the response. Current retryCount == " + retryCount);
            }
            throw new RetriableException("Fake Exception");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("retryCount == " + retryCount + ". It's time to normally process the response");
        }
        return result;
    }
}

