/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.fs;

import org.apache.flink.fs.shaded.hadoop3.com.google.re2j.Pattern;
import org.apache.flink.fs.shaded.hadoop3.com.google.re2j.PatternSyntaxException;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceAudience;
import org.apache.flink.fs.shaded.hadoop3.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class GlobPattern {
    private static final char BACKSLASH = '\\';
    private Pattern compiled;
    private boolean hasWildcard = false;

    public GlobPattern(String globPattern) {
        this.set(globPattern);
    }

    public Pattern compiled() {
        return this.compiled;
    }

    public static Pattern compile(String globPattern) {
        return new GlobPattern(globPattern).compiled();
    }

    public boolean matches(CharSequence s) {
        return this.compiled.matcher(s).matches();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void set(String glob) {
        StringBuilder regex = new StringBuilder();
        int setOpen = 0;
        int curlyOpen = 0;
        int len = glob.length();
        this.hasWildcard = false;
        block13: for (int i = 0; i < len; ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= len) {
                        GlobPattern.error("Missing escaped character", glob, i);
                    }
                    regex.append(c).append(glob.charAt(i));
                    continue block13;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '|': {
                    regex.append('\\');
                    break;
                }
                case '*': {
                    regex.append('.');
                    this.hasWildcard = true;
                    break;
                }
                case '?': {
                    regex.append('.');
                    this.hasWildcard = true;
                    continue block13;
                }
                case '{': {
                    regex.append("(?:");
                    ++curlyOpen;
                    this.hasWildcard = true;
                    continue block13;
                }
                case ',': {
                    regex.append(curlyOpen > 0 ? (char)'|' : (char)c);
                    continue block13;
                }
                case '}': {
                    if (curlyOpen <= 0) break;
                    --curlyOpen;
                    regex.append(")");
                    continue block13;
                }
                case '[': {
                    if (setOpen > 0) {
                        GlobPattern.error("Unclosed character class", glob, i);
                    }
                    ++setOpen;
                    this.hasWildcard = true;
                    break;
                }
                case '^': {
                    if (setOpen != 0) break;
                    regex.append('\\');
                    break;
                }
                case '!': {
                    regex.append((char)(setOpen > 0 && '[' == glob.charAt(i - 1) ? 94 : 33));
                    continue block13;
                }
                case ']': {
                    setOpen = 0;
                }
            }
            regex.append(c);
        }
        if (setOpen > 0) {
            GlobPattern.error("Unclosed character class", glob, len);
        }
        if (curlyOpen > 0) {
            GlobPattern.error("Unclosed group", glob, len);
        }
        this.compiled = Pattern.compile(regex.toString(), 2);
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }

    private static void error(String message, String pattern, int pos) {
        String fullMessage = String.format("%s at pos %d", message, pos);
        throw new PatternSyntaxException(fullMessage, pattern);
    }
}

