/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal;

import java.io.InputStream;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.CheckedInputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParseException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParser;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.CodingUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.DateUtil;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.HttpUtil;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.AccessControlList;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.AddBucketReplicationRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.AppendObjectResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Bucket;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketList;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketLoggingResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketMetadata;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketProcess;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketReferer;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketReplicationProgress;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketStat;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.BucketWebsiteResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CannedAccessControlList;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CannedUdfAcl;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CnameConfiguration;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CompleteMultipartUploadResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CopyObjectResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.CreateLiveChannelResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.DeleteObjectsResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GenericResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GetBucketImageResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GetImageStyleResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.GroupGrantee;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ImageProcess;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.InitiateMultipartUploadResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.InstanceFlavor;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LifecycleRule;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannel;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannelInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannelListing;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannelStat;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannelStatus;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveChannelTarget;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.LiveRecord;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.MultipartUpload;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.MultipartUploadListing;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.OSSObject;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.OSSObjectSummary;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.OSSSymlink;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ObjectAcl;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ObjectListing;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ObjectMetadata;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ObjectPermission;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Owner;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.PartListing;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.PartSummary;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Permission;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.PushflowStatus;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.PutObjectResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ReplicationRule;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.ReplicationStatus;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.RestoreObjectResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.RoutingRule;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.SetBucketCORSRequest;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.SimplifiedObjectMeta;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.StorageClass;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.Style;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.TagSet;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfApplicationInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfApplicationLog;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfImageInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UdfInfo;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UploadPartCopyResult;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.model.UserQos;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;

public final class ResponseParsers {
    public static final ListBucketResponseParser listBucketResponseParser = new ListBucketResponseParser();
    public static final ListImageStyleResponseParser listImageStyleResponseParser = new ListImageStyleResponseParser();
    public static final GetBucketRefererResponseParser getBucketRefererResponseParser = new GetBucketRefererResponseParser();
    public static final GetBucketAclResponseParser getBucketAclResponseParser = new GetBucketAclResponseParser();
    public static final GetBucketMetadataResponseParser getBucketMetadataResponseParser = new GetBucketMetadataResponseParser();
    public static final GetBucketLocationResponseParser getBucketLocationResponseParser = new GetBucketLocationResponseParser();
    public static final GetBucketLoggingResponseParser getBucketLoggingResponseParser = new GetBucketLoggingResponseParser();
    public static final GetBucketWebsiteResponseParser getBucketWebsiteResponseParser = new GetBucketWebsiteResponseParser();
    public static final GetBucketLifecycleResponseParser getBucketLifecycleResponseParser = new GetBucketLifecycleResponseParser();
    public static final GetBucketCorsResponseParser getBucketCorsResponseParser = new GetBucketCorsResponseParser();
    public static final GetBucketImageResponseParser getBucketImageResponseParser = new GetBucketImageResponseParser();
    public static final GetImageStyleResponseParser getImageStyleResponseParser = new GetImageStyleResponseParser();
    public static final GetBucketImageProcessConfResponseParser getBucketImageProcessConfResponseParser = new GetBucketImageProcessConfResponseParser();
    public static final GetBucketTaggingResponseParser getBucketTaggingResponseParser = new GetBucketTaggingResponseParser();
    public static final GetBucketReplicationResponseParser getBucketReplicationResponseParser = new GetBucketReplicationResponseParser();
    public static final GetBucketReplicationProgressResponseParser getBucketReplicationProgressResponseParser = new GetBucketReplicationProgressResponseParser();
    public static final GetBucketReplicationLocationResponseParser getBucketReplicationLocationResponseParser = new GetBucketReplicationLocationResponseParser();
    public static final GetBucketCnameResponseParser getBucketCnameResponseParser = new GetBucketCnameResponseParser();
    public static final GetBucketInfoResponseParser getBucketInfoResponseParser = new GetBucketInfoResponseParser();
    public static final GetBucketStatResponseParser getBucketStatResponseParser = new GetBucketStatResponseParser();
    public static final GetBucketQosResponseParser getBucketQosResponseParser = new GetBucketQosResponseParser();
    public static final ListObjectsReponseParser listObjectsReponseParser = new ListObjectsReponseParser();
    public static final PutObjectReponseParser putObjectReponseParser = new PutObjectReponseParser();
    public static final PutObjectProcessReponseParser putObjectProcessReponseParser = new PutObjectProcessReponseParser();
    public static final AppendObjectResponseParser appendObjectResponseParser = new AppendObjectResponseParser();
    public static final GetObjectMetadataResponseParser getObjectMetadataResponseParser = new GetObjectMetadataResponseParser();
    public static final CopyObjectResponseParser copyObjectResponseParser = new CopyObjectResponseParser();
    public static final DeleteObjectsResponseParser deleteObjectsResponseParser = new DeleteObjectsResponseParser();
    public static final GetObjectAclResponseParser getObjectAclResponseParser = new GetObjectAclResponseParser();
    public static final GetSimplifiedObjectMetaResponseParser getSimplifiedObjectMetaResponseParser = new GetSimplifiedObjectMetaResponseParser();
    public static final RestoreObjectResponseParser restoreObjectResponseParser = new RestoreObjectResponseParser();
    public static final ProcessObjectResponseParser processObjectResponseParser = new ProcessObjectResponseParser();
    public static final HeadObjectResponseParser headObjectResponseParser = new HeadObjectResponseParser();
    public static final CompleteMultipartUploadResponseParser completeMultipartUploadResponseParser = new CompleteMultipartUploadResponseParser();
    public static final CompleteMultipartUploadProcessResponseParser completeMultipartUploadProcessResponseParser = new CompleteMultipartUploadProcessResponseParser();
    public static final InitiateMultipartUploadResponseParser initiateMultipartUploadResponseParser = new InitiateMultipartUploadResponseParser();
    public static final ListMultipartUploadsResponseParser listMultipartUploadsResponseParser = new ListMultipartUploadsResponseParser();
    public static final ListPartsResponseParser listPartsResponseParser = new ListPartsResponseParser();
    public static final CreateLiveChannelResponseParser createLiveChannelResponseParser = new CreateLiveChannelResponseParser();
    public static final GetLiveChannelInfoResponseParser getLiveChannelInfoResponseParser = new GetLiveChannelInfoResponseParser();
    public static final GetLiveChannelStatResponseParser getLiveChannelStatResponseParser = new GetLiveChannelStatResponseParser();
    public static final GetLiveChannelHistoryResponseParser getLiveChannelHistoryResponseParser = new GetLiveChannelHistoryResponseParser();
    public static final ListLiveChannelsReponseParser listLiveChannelsReponseParser = new ListLiveChannelsReponseParser();
    public static final GetSymbolicLinkResponseParser getSymbolicLinkResponseParser = new GetSymbolicLinkResponseParser();
    public static final GetUdfInfoResponseParser getUdfInfoResponseParser = new GetUdfInfoResponseParser();
    public static final ListUdfResponseParser listUdfResponseParser = new ListUdfResponseParser();
    public static final GetUdfImageInfoResponseParser getUdfImageInfoResponseParser = new GetUdfImageInfoResponseParser();
    public static final GetUdfApplicationInfoResponseParser getUdfApplicationInfoResponseParser = new GetUdfApplicationInfoResponseParser();
    public static final ListUdfApplicationInfoResponseParser listUdfApplicationInfoResponseParser = new ListUdfApplicationInfoResponseParser();

    public static <ResultType extends GenericResult> void setCRC(ResultType result, ResponseMessage response) {
        String strSrvCrc;
        InputStream inputStream = response.getRequest().getContent();
        if (inputStream instanceof CheckedInputStream) {
            CheckedInputStream checkedInputStream = (CheckedInputStream)inputStream;
            result.setClientCRC(checkedInputStream.getChecksum().getValue());
        }
        if ((strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma")) != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }

    public static <ResultType extends GenericResult> void setServerCRC(ResultType result, ResponseMessage response) {
        String strSrvCrc = response.getHeaders().get("x-oss-hash-crc64ecma");
        if (strSrvCrc != null) {
            BigInteger bi = new BigInteger(strSrvCrc);
            result.setServerCRC(bi.longValue());
        }
    }

    private static Element getXmlRootElement(InputStream responseBody) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(responseBody);
        return doc.getRootElement();
    }

    public static ObjectListing parseListObjects(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectListing objectListing = new ObjectListing();
            objectListing.setBucketName(root.getChildText("Name"));
            objectListing.setMaxKeys(Integer.valueOf(root.getChildText("MaxKeys")));
            objectListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                objectListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                objectListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("Delimiter") != null) {
                String delimiter = root.getChildText("Delimiter");
                objectListing.setDelimiter(CodingUtils.isNullOrEmpty(delimiter) ? null : delimiter);
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                objectListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                objectListing.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            List objectSummaryElems = root.getChildren("Contents");
            for (Element elem : objectSummaryElems) {
                OSSObjectSummary ossObjectSummary = new OSSObjectSummary();
                ossObjectSummary.setKey(elem.getChildText("Key"));
                ossObjectSummary.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ossObjectSummary.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ossObjectSummary.setSize(Long.valueOf(elem.getChildText("Size")));
                ossObjectSummary.setStorageClass(elem.getChildText("StorageClass"));
                ossObjectSummary.setBucketName(objectListing.getBucketName());
                String id = elem.getChild("Owner").getChildText("ID");
                String displayName = elem.getChild("Owner").getChildText("DisplayName");
                ossObjectSummary.setOwner(new Owner(id, displayName));
                objectListing.addObjectSummary(ossObjectSummary);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix)) continue;
                objectListing.addCommonPrefix(prefix);
            }
            return objectListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static AccessControlList parseGetBucketAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            AccessControlList acl = new AccessControlList();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String aclString = root.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList cacl = CannedAccessControlList.parse(aclString);
            acl.setCannedACL(cacl);
            switch (cacl) {
                case PublicRead: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    acl.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectAcl parseGetObjectAcl(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ObjectAcl acl = new ObjectAcl();
            String id = root.getChild("Owner").getChildText("ID");
            String displayName = root.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            acl.setOwner(owner);
            String grantString = root.getChild("AccessControlList").getChildText("Grant");
            acl.setPermission(ObjectPermission.parsePermission(grantString));
            return acl;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReferer parseGetBucketReferer(InputStream responseBody) throws ResponseParseException {
        try {
            Element refererListElem;
            List refererElems;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            boolean allowEmptyReferer = Boolean.valueOf(root.getChildText("AllowEmptyReferer"));
            ArrayList<String> refererList = new ArrayList<String>();
            if (root.getChild("RefererList") != null && (refererElems = (refererListElem = root.getChild("RefererList")).getChildren("Referer")) != null && !refererElems.isEmpty()) {
                for (Element e : refererElems) {
                    refererList.add(e.getText());
                }
            }
            return new BucketReferer(allowEmptyReferer, refererList);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseUploadPartCopy(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getChildText("ETag");
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketList parseListBucket(InputStream responseBody) throws ResponseParseException {
        try {
            String value;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketList bucketList = new BucketList();
            if (root.getChild("Prefix") != null) {
                bucketList.setPrefix(root.getChildText("Prefix"));
            }
            if (root.getChild("Marker") != null) {
                bucketList.setMarker(root.getChildText("Marker"));
            }
            if (root.getChild("MaxKeys") != null) {
                value = root.getChildText("MaxKeys");
                bucketList.setMaxKeys(CodingUtils.isNullOrEmpty(value) ? null : Integer.valueOf(value));
            }
            if (root.getChild("IsTruncated") != null) {
                value = root.getChildText("IsTruncated");
                bucketList.setTruncated(CodingUtils.isNullOrEmpty(value) ? false : Boolean.valueOf(value));
            }
            if (root.getChild("NextMarker") != null) {
                bucketList.setNextMarker(root.getChildText("NextMarker"));
            }
            Element ownerElem = root.getChild("Owner");
            String id = ownerElem.getChildText("ID");
            String displayName = ownerElem.getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            ArrayList<Bucket> buckets = new ArrayList<Bucket>();
            if (root.getChild("Buckets") != null) {
                List bucketElems = root.getChild("Buckets").getChildren("Bucket");
                for (Element e : bucketElems) {
                    Bucket bucket = new Bucket();
                    bucket.setOwner(owner);
                    bucket.setName(e.getChildText("Name"));
                    bucket.setLocation(e.getChildText("Location"));
                    bucket.setCreationDate(DateUtil.parseIso8601Date(e.getChildText("CreationDate")));
                    if (e.getChild("StorageClass") != null) {
                        bucket.setStorageClass(StorageClass.parse(e.getChildText("StorageClass")));
                    }
                    bucket.setExtranetEndpoint(e.getChildText("ExtranetEndpoint"));
                    bucket.setIntranetEndpoint(e.getChildText("IntranetEndpoint"));
                    buckets.add(bucket);
                }
            }
            bucketList.setBucketList(buckets);
            return bucketList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<Style> parseListImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<Style> styleList = new ArrayList<Style>();
            List styleElems = root.getChildren("Style");
            for (Element e : styleElems) {
                Style style = new Style();
                style.SetStyleName(e.getChildText("Name"));
                style.SetStyle(e.getChildText("Content"));
                style.SetLastModifyTime(DateUtil.parseRfc822Date(e.getChildText("LastModifyTime")));
                style.SetCreationDate(DateUtil.parseRfc822Date(e.getChildText("CreateTime")));
                styleList.add(style);
            }
            return styleList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static String parseGetBucketLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            return root.getText();
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketMetadata parseBucketMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            BucketMetadata bucketMetadata = new BucketMetadata();
            for (String key : headers.keySet()) {
                if (key.equals("x-oss-bucket-region")) {
                    bucketMetadata.setBucketRegion(headers.get(key));
                    continue;
                }
                bucketMetadata.addHttpMetadata(key, headers.get(key));
            }
            return bucketMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static SimplifiedObjectMeta parseSimplifiedObjectMeta(Map<String, String> headers) throws ResponseParseException {
        try {
            SimplifiedObjectMeta objectMeta = new SimplifiedObjectMeta();
            for (String key : headers.keySet()) {
                if (key.equals("Last-Modified")) {
                    try {
                        objectMeta.setLastModified(DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMeta.setSize(value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMeta.setETag(OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                if (!key.equals("x-oss-request-id")) continue;
                objectMeta.setRequestId(headers.get(key));
            }
            return objectMeta;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static OSSSymlink parseSymbolicLink(ResponseMessage response) throws ResponseParseException {
        try {
            OSSSymlink smyLink = null;
            String targetObject = response.getHeaders().get("x-oss-symlink-target");
            if (targetObject != null) {
                targetObject = HttpUtil.urlDecode(targetObject, "UTF-8");
                smyLink = new OSSSymlink(null, targetObject);
            }
            smyLink.setMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
            return smyLink;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UdfInfo parseGetUdfInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String name = root.getChildText("Name");
            String id = root.getChildText("ID");
            String owner = root.getChildText("Owner");
            String desc = root.getChildText("Description");
            Date date = DateUtil.parseIso8601Date(root.getChildText("CreationDate"));
            CannedUdfAcl acl = CannedUdfAcl.parse(root.getChildText("ACL"));
            return new UdfInfo(name, owner, id, desc, acl, date);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<UdfInfo> parseListUdf(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<UdfInfo> udfs = new ArrayList<UdfInfo>();
            if (root.getChild("UDFInfo") != null) {
                List udfElems = root.getChildren("UDFInfo");
                for (Element elem : udfElems) {
                    String name = elem.getChildText("Name");
                    String id = elem.getChildText("ID");
                    String owner = elem.getChildText("Owner");
                    String desc = elem.getChildText("Description");
                    Date date = DateUtil.parseIso8601Date(elem.getChildText("CreationDate"));
                    CannedUdfAcl acl = CannedUdfAcl.parse(elem.getChildText("ACL"));
                    udfs.add(new UdfInfo(name, owner, id, desc, acl, date));
                }
            }
            return udfs;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<UdfImageInfo> parseGetUdfImageInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<UdfImageInfo> udfImages = new ArrayList<UdfImageInfo>();
            if (root.getChild("Item") != null) {
                List udfImageElems = root.getChildren("Item");
                for (Element elem : udfImageElems) {
                    Integer version = Integer.valueOf(elem.getChildText("Version"));
                    String status = elem.getChildText("Status");
                    String region = elem.getChildText("CanonicalRegion");
                    String desc = elem.getChildText("Description");
                    Date date = DateUtil.parseIso8601Date(elem.getChildText("CreationDate"));
                    udfImages.add(new UdfImageInfo(version, status, desc, region, date));
                }
            }
            return udfImages;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UdfApplicationInfo parseGetUdfApplicationInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String id = root.getChildText("ID");
            String name = root.getChildText("Name");
            String status = root.getChildText("Status");
            String region = root.getChildText("Region");
            Integer imageVersion = Integer.valueOf(root.getChildText("ImageVersion"));
            Integer instanceNum = Integer.valueOf(root.getChildText("InstanceNum"));
            Date date = DateUtil.parseIso8601Date(root.getChildText("CreationDate"));
            String instanceType = root.getChild("Flavor").getChildText("InstanceType");
            InstanceFlavor flavor = new InstanceFlavor(instanceType);
            return new UdfApplicationInfo(name, id, region, status, imageVersion, instanceNum, date, flavor);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<UdfApplicationInfo> parseListUdfApplicationInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<UdfApplicationInfo> udfApps = new ArrayList<UdfApplicationInfo>();
            if (root.getChild("UDFApplicationInfo") != null) {
                List udfImageElems = root.getChildren("UDFApplicationInfo");
                for (Element elem : udfImageElems) {
                    String id = elem.getChildText("ID");
                    String name = elem.getChildText("Name");
                    String status = elem.getChildText("Status");
                    String region = elem.getChildText("Region");
                    Integer imageVersion = Integer.valueOf(elem.getChildText("ImageVersion"));
                    Integer instanceNum = Integer.valueOf(elem.getChildText("InstanceNum"));
                    Date date = DateUtil.parseIso8601Date(elem.getChildText("CreationDate"));
                    String instanceType = elem.getChild("Flavor").getChildText("InstanceType");
                    InstanceFlavor flavor = new InstanceFlavor(instanceType);
                    UdfApplicationInfo udfApp = new UdfApplicationInfo(name, id, region, status, imageVersion, instanceNum, date, flavor);
                    udfApps.add(udfApp);
                }
            }
            return udfApps;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static ObjectMetadata parseObjectMetadata(Map<String, String> headers) throws ResponseParseException {
        try {
            ObjectMetadata objectMetadata = new ObjectMetadata();
            for (String key : headers.keySet()) {
                if (key.indexOf("x-oss-meta-") >= 0) {
                    key = key.substring("x-oss-meta-".length());
                    objectMetadata.addUserMetadata(key, headers.get("x-oss-meta-" + key));
                    continue;
                }
                if (key.equals("Last-Modified") || key.equals("Date")) {
                    try {
                        objectMetadata.setHeader(key, DateUtil.parseRfc822Date(headers.get(key)));
                        continue;
                    }
                    catch (ParseException pe) {
                        throw new ResponseParseException(pe.getMessage(), pe);
                    }
                }
                if (key.equals("Content-Length")) {
                    Long value = Long.valueOf(headers.get(key));
                    objectMetadata.setHeader(key, value);
                    continue;
                }
                if (key.equals("ETag")) {
                    objectMetadata.setHeader(key, OSSUtils.trimQuotes(headers.get(key)));
                    continue;
                }
                objectMetadata.setHeader(key, headers.get(key));
            }
            return objectMetadata;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static InitiateMultipartUploadResult parseInitiateMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            InitiateMultipartUploadResult result = new InitiateMultipartUploadResult();
            if (root.getChild("Bucket") != null) {
                result.setBucketName(root.getChildText("Bucket"));
            }
            if (root.getChild("Key") != null) {
                result.setKey(root.getChildText("Key"));
            }
            if (root.getChild("UploadId") != null) {
                result.setUploadId(root.getChildText("UploadId"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static MultipartUploadListing parseListMultipartUploads(InputStream responseBody) throws ResponseParseException {
        try {
            String nextUploadIdMarker;
            String nextKeyMarker;
            String uploadIdMarker;
            String keyMarker;
            String prefix;
            String delimiter;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            MultipartUploadListing multipartUploadListing = new MultipartUploadListing();
            multipartUploadListing.setBucketName(root.getChildText("Bucket"));
            multipartUploadListing.setMaxUploads(Integer.valueOf(root.getChildText("MaxUploads")));
            multipartUploadListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Delimiter") != null && !CodingUtils.isNullOrEmpty(delimiter = root.getChildText("Delimiter"))) {
                multipartUploadListing.setDelimiter(delimiter);
            }
            if (root.getChild("Prefix") != null && !CodingUtils.isNullOrEmpty(prefix = root.getChildText("Prefix"))) {
                multipartUploadListing.setPrefix(prefix);
            }
            if (root.getChild("KeyMarker") != null && !CodingUtils.isNullOrEmpty(keyMarker = root.getChildText("KeyMarker"))) {
                multipartUploadListing.setKeyMarker(keyMarker);
            }
            if (root.getChild("UploadIdMarker") != null && !CodingUtils.isNullOrEmpty(uploadIdMarker = root.getChildText("UploadIdMarker"))) {
                multipartUploadListing.setUploadIdMarker(uploadIdMarker);
            }
            if (root.getChild("NextKeyMarker") != null && !CodingUtils.isNullOrEmpty(nextKeyMarker = root.getChildText("NextKeyMarker"))) {
                multipartUploadListing.setNextKeyMarker(nextKeyMarker);
            }
            if (root.getChild("NextUploadIdMarker") != null && !CodingUtils.isNullOrEmpty(nextUploadIdMarker = root.getChildText("NextUploadIdMarker"))) {
                multipartUploadListing.setNextUploadIdMarker(nextUploadIdMarker);
            }
            List uploadElems = root.getChildren("Upload");
            for (Element elem : uploadElems) {
                if (elem.getChild("Initiated") == null) continue;
                MultipartUpload mu = new MultipartUpload();
                mu.setKey(elem.getChildText("Key"));
                mu.setUploadId(elem.getChildText("UploadId"));
                mu.setStorageClass(elem.getChildText("StorageClass"));
                mu.setInitiated(DateUtil.parseIso8601Date(elem.getChildText("Initiated")));
                multipartUploadListing.addMultipartUpload(mu);
            }
            List commonPrefixesElems = root.getChildren("CommonPrefixes");
            for (Element elem : commonPrefixesElems) {
                String prefix2 = elem.getChildText("Prefix");
                if (CodingUtils.isNullOrEmpty(prefix2)) continue;
                multipartUploadListing.addCommonPrefix(prefix2);
            }
            return multipartUploadListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static PartListing parseListParts(InputStream responseBody) throws ResponseParseException {
        try {
            String nextPartNumberMarker;
            String partNumberMarker;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            PartListing partListing = new PartListing();
            partListing.setBucketName(root.getChildText("Bucket"));
            partListing.setKey(root.getChildText("Key"));
            partListing.setUploadId(root.getChildText("UploadId"));
            partListing.setStorageClass(root.getChildText("StorageClass"));
            partListing.setMaxParts(Integer.valueOf(root.getChildText("MaxParts")));
            partListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("PartNumberMarker") != null && !CodingUtils.isNullOrEmpty(partNumberMarker = root.getChildText("PartNumberMarker"))) {
                partListing.setPartNumberMarker(Integer.valueOf(partNumberMarker));
            }
            if (root.getChild("NextPartNumberMarker") != null && !CodingUtils.isNullOrEmpty(nextPartNumberMarker = root.getChildText("NextPartNumberMarker"))) {
                partListing.setNextPartNumberMarker(Integer.valueOf(nextPartNumberMarker));
            }
            List partElems = root.getChildren("Part");
            for (Element elem : partElems) {
                PartSummary ps = new PartSummary();
                ps.setPartNumber(Integer.valueOf(elem.getChildText("PartNumber")));
                ps.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ps.setETag(OSSUtils.trimQuotes(elem.getChildText("ETag")));
                ps.setSize(Integer.valueOf(elem.getChildText("Size")).intValue());
                partListing.addPart(ps);
            }
            return partListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CompleteMultipartUploadResult parseCompleteMultipartUpload(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setBucketName(root.getChildText("Bucket"));
            result.setETag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            result.setKey(root.getChildText("Key"));
            result.setLocation(root.getChildText("Location"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketLoggingResult parseBucketLogging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketLoggingResult result = new BucketLoggingResult();
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetBucket(root.getChild("LoggingEnabled").getChildText("TargetBucket"));
            }
            if (root.getChild("LoggingEnabled") != null) {
                result.setTargetPrefix(root.getChild("LoggingEnabled").getChildText("TargetPrefix"));
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetBucketImageResult parseBucketImage(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetBucketImageResult result = new GetBucketImageResult();
            result.SetBucketName(root.getChildText("Name"));
            result.SetDefault404Pic(root.getChildText("Default404Pic"));
            result.SetStyleDelimiters(root.getChildText("StyleDelimiters"));
            result.SetStatus(root.getChildText("Status"));
            result.SetIsAutoSetContentType(root.getChildText("AutoSetContentType").equals("True"));
            result.SetIsForbidOrigPicAccess(root.getChildText("OrigPicForbidden").equals("True"));
            result.SetIsSetAttachName(root.getChildText("SetAttachName").equals("True"));
            result.SetIsUseStyleOnly(root.getChildText("UseStyleOnly").equals("True"));
            result.SetIsUseSrcFormat(root.getChildText("UseSrcFormat").equals("True"));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static GetImageStyleResult parseImageStyle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            GetImageStyleResult result = new GetImageStyleResult();
            result.SetStyleName(root.getChildText("Name"));
            result.SetStyle(root.getChildText("Content"));
            result.SetLastModifyTime(DateUtil.parseRfc822Date(root.getChildText("LastModifyTime")));
            result.SetCreationDate(DateUtil.parseRfc822Date(root.getChildText("CreateTime")));
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketProcess parseGetBucketImageProcessConf(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            String compliedHost = root.getChildText("CompliedHost");
            boolean sourceFileProtect = false;
            if (root.getChildText("SourceFileProtect").equals("Enabled")) {
                sourceFileProtect = true;
            }
            String sourceFileProtectSuffix = root.getChildText("SourceFileProtectSuffix");
            String styleDelimiters = root.getChildText("StyleDelimiters");
            ImageProcess imageProcess = new ImageProcess(compliedHost, sourceFileProtect, sourceFileProtectSuffix, styleDelimiters);
            if (root.getChildText("Version") != null) {
                imageProcess.setVersion(Integer.parseInt(root.getChildText("Version")));
            }
            return new BucketProcess(imageProcess);
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketWebsiteResult parseBucketWebsite(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            BucketWebsiteResult result = new BucketWebsiteResult();
            if (root.getChild("IndexDocument") != null) {
                result.setIndexDocument(root.getChild("IndexDocument").getChildText("Suffix"));
            }
            if (root.getChild("ErrorDocument") != null) {
                result.setErrorDocument(root.getChild("ErrorDocument").getChildText("Key"));
            }
            if (root.getChild("RoutingRules") != null) {
                List ruleElements = root.getChild("RoutingRules").getChildren("RoutingRule");
                for (Element ruleElem : ruleElements) {
                    Element redirectElem;
                    RoutingRule rule = new RoutingRule();
                    rule.setNumber(Integer.parseInt(ruleElem.getChildText("RuleNumber")));
                    Element condElem = ruleElem.getChild("Condition");
                    if (condElem != null) {
                        rule.getCondition().setKeyPrefixEquals(condElem.getChildText("KeyPrefixEquals"));
                        if (condElem.getChild("HttpErrorCodeReturnedEquals") != null) {
                            rule.getCondition().setHttpErrorCodeReturnedEquals(Integer.parseInt(condElem.getChildText("HttpErrorCodeReturnedEquals")));
                        }
                    }
                    if ((redirectElem = ruleElem.getChild("Redirect")).getChild("RedirectType") != null) {
                        rule.getRedirect().setRedirectType(RoutingRule.RedirectType.parse(redirectElem.getChildText("RedirectType")));
                    }
                    rule.getRedirect().setHostName(redirectElem.getChildText("HostName"));
                    if (redirectElem.getChild("Protocol") != null) {
                        rule.getRedirect().setProtocol(RoutingRule.Protocol.parse(redirectElem.getChildText("Protocol")));
                    }
                    rule.getRedirect().setReplaceKeyPrefixWith(redirectElem.getChildText("ReplaceKeyPrefixWith"));
                    rule.getRedirect().setReplaceKeyWith(redirectElem.getChildText("ReplaceKeyWith"));
                    if (redirectElem.getChild("HttpRedirectCode") != null) {
                        rule.getRedirect().setHttpRedirectCode(Integer.parseInt(redirectElem.getChildText("HttpRedirectCode")));
                    }
                    rule.getRedirect().setMirrorURL(redirectElem.getChildText("MirrorURL"));
                    rule.getRedirect().setMirrorSecondaryURL(redirectElem.getChildText("MirrorURLSlave"));
                    rule.getRedirect().setMirrorProbeURL(redirectElem.getChildText("MirrorURLProbe"));
                    if (redirectElem.getChildText("MirrorPassQueryString") != null) {
                        rule.getRedirect().setPassQueryString(Boolean.valueOf(redirectElem.getChildText("MirrorPassQueryString")));
                    }
                    if (redirectElem.getChildText("MirrorPassOriginalSlashes") != null) {
                        rule.getRedirect().setPassOriginalSlashes(Boolean.valueOf(redirectElem.getChildText("MirrorPassOriginalSlashes")));
                    }
                    result.AddRoutingRule(rule);
                }
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CopyObjectResult parseCopyObjectResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CopyObjectResult result = new CopyObjectResult();
            result.setLastModified(DateUtil.parseIso8601Date(root.getChildText("LastModified")));
            result.setEtag(OSSUtils.trimQuotes(root.getChildText("ETag")));
            return result;
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static DeleteObjectsResult parseDeleteObjectsResult(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            DeleteObjectsResult deleteObjectsResult = new DeleteObjectsResult();
            if (root.getChild("EncodingType") != null) {
                String encodingType = root.getChildText("EncodingType");
                deleteObjectsResult.setEncodingType(CodingUtils.isNullOrEmpty(encodingType) ? null : encodingType);
            }
            ArrayList<String> deletedObjects = new ArrayList<String>();
            List deletedElements = root.getChildren("Deleted");
            for (Element elem : deletedElements) {
                deletedObjects.add(elem.getChildText("Key"));
            }
            deleteObjectsResult.setDeletedObjects(deletedObjects);
            return deleteObjectsResult;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<SetBucketCORSRequest.CORSRule> parseListBucketCORS(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<SetBucketCORSRequest.CORSRule> corsRules = new ArrayList<SetBucketCORSRequest.CORSRule>();
            List corsRuleElems = root.getChildren("CORSRule");
            for (Element corsRuleElem : corsRuleElems) {
                SetBucketCORSRequest.CORSRule rule = new SetBucketCORSRequest.CORSRule();
                List allowedOriginElems = corsRuleElem.getChildren("AllowedOrigin");
                for (Element allowedOriginElement : allowedOriginElems) {
                    rule.getAllowedOrigins().add(allowedOriginElement.getValue());
                }
                List allowedMethodElems = corsRuleElem.getChildren("AllowedMethod");
                for (Element allowedMethodElement : allowedMethodElems) {
                    rule.getAllowedMethods().add(allowedMethodElement.getValue());
                }
                List allowedHeaderElems = corsRuleElem.getChildren("AllowedHeader");
                for (Element allowedHeaderElement : allowedHeaderElems) {
                    rule.getAllowedHeaders().add(allowedHeaderElement.getValue());
                }
                List exposeHeaderElems = corsRuleElem.getChildren("ExposeHeader");
                for (Element exposeHeaderElement : exposeHeaderElems) {
                    rule.getExposeHeaders().add(exposeHeaderElement.getValue());
                }
                Element maxAgeSecondsElem = corsRuleElem.getChild("MaxAgeSeconds");
                if (maxAgeSecondsElem != null) {
                    rule.setMaxAgeSeconds(Integer.parseInt(maxAgeSecondsElem.getValue()));
                }
                corsRules.add(rule);
            }
            return corsRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static TagSet parseGetBucketTagging(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            TagSet tagSet = new TagSet();
            List tagElems = root.getChild("TagSet").getChildren("Tag");
            for (Element tagElem : tagElems) {
                String key = null;
                String value = null;
                if (tagElem.getChild("Key") != null) {
                    key = tagElem.getChildText("Key");
                }
                if (tagElem.getChild("Value") != null) {
                    value = tagElem.getChildText("Value");
                }
                tagSet.setTag(key, value);
            }
            return tagSet;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<ReplicationRule> parseGetBucketReplication(InputStream responseBody) throws ResponseParseException {
        try {
            ArrayList<ReplicationRule> repRules = new ArrayList<ReplicationRule>();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            List ruleElems = root.getChildren("Rule");
            for (Element ruleElem : ruleElems) {
                ReplicationRule repRule = new ReplicationRule();
                repRule.setReplicationRuleID(ruleElem.getChildText("ID"));
                Element destination = ruleElem.getChild("Destination");
                repRule.setTargetBucketName(destination.getChildText("Bucket"));
                repRule.setTargetBucketLocation(destination.getChildText("Location"));
                repRule.setTargetCloud(destination.getChildText("Cloud"));
                repRule.setTargetCloudLocation(destination.getChildText("CloudLocation"));
                repRule.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
                if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                    repRule.setEnableHistoricalObjectReplication(true);
                } else {
                    repRule.setEnableHistoricalObjectReplication(false);
                }
                if (ruleElem.getChild("PrefixSet") != null) {
                    ArrayList<String> objectPrefixes = new ArrayList<String>();
                    List prefixElems = ruleElem.getChild("PrefixSet").getChildren("Prefix");
                    for (Element prefixElem : prefixElems) {
                        objectPrefixes.add(prefixElem.getText());
                    }
                    repRule.setObjectPrefixList(objectPrefixes);
                }
                if (ruleElem.getChild("Action") != null) {
                    String[] actionStrs = ruleElem.getChildText("Action").split(",");
                    ArrayList<AddBucketReplicationRequest.ReplicationAction> repActions = new ArrayList<AddBucketReplicationRequest.ReplicationAction>();
                    for (String actionStr : actionStrs) {
                        repActions.add(AddBucketReplicationRequest.ReplicationAction.parse(actionStr));
                    }
                    repRule.setReplicationActionList(repActions);
                }
                repRules.add(repRule);
            }
            return repRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketReplicationProgress parseGetBucketReplicationProgress(InputStream responseBody) throws ResponseParseException {
        try {
            BucketReplicationProgress progress = new BucketReplicationProgress();
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element ruleElem = root.getChild("Rule");
            progress.setReplicationRuleID(ruleElem.getChildText("ID"));
            Element destination = ruleElem.getChild("Destination");
            progress.setTargetBucketName(destination.getChildText("Bucket"));
            progress.setTargetBucketLocation(destination.getChildText("Location"));
            progress.setTargetCloud(destination.getChildText("Cloud"));
            progress.setTargetCloudLocation(destination.getChildText("CloudLocation"));
            progress.setReplicationStatus(ReplicationStatus.parse(ruleElem.getChildText("Status")));
            if (ruleElem.getChildText("HistoricalObjectReplication").equals("enabled")) {
                progress.setEnableHistoricalObjectReplication(true);
            } else {
                progress.setEnableHistoricalObjectReplication(false);
            }
            Element progressElem = ruleElem.getChild("Progress");
            if (progressElem != null) {
                if (progressElem.getChild("HistoricalObject") != null) {
                    progress.setHistoricalObjectProgress(Float.parseFloat(progressElem.getChildText("HistoricalObject")));
                }
                progress.setNewObjectProgress(DateUtil.parseIso8601Date(progressElem.getChildText("NewObject")));
            }
            return progress;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<String> parseGetBucketReplicationLocation(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<String> locationList = new ArrayList<String>();
            List locElements = root.getChildren("Location");
            for (Element locElem : locElements) {
                locationList.add(locElem.getText());
            }
            return locationList;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketInfo parseGetBucketInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Element bucketElem = root.getChild("Bucket");
            BucketInfo bucketInfo = new BucketInfo();
            Bucket bucket = new Bucket();
            String id = bucketElem.getChild("Owner").getChildText("ID");
            String displayName = bucketElem.getChild("Owner").getChildText("DisplayName");
            Owner owner = new Owner(id, displayName);
            bucket.setOwner(owner);
            bucket.setName(bucketElem.getChildText("Name"));
            bucket.setLocation(bucketElem.getChildText("Location"));
            bucket.setExtranetEndpoint(bucketElem.getChildText("ExtranetEndpoint"));
            bucket.setIntranetEndpoint(bucketElem.getChildText("IntranetEndpoint"));
            bucket.setCreationDate(DateUtil.parseIso8601Date(bucketElem.getChildText("CreationDate")));
            if (bucketElem.getChild("StorageClass") != null) {
                bucket.setStorageClass(StorageClass.parse(bucketElem.getChildText("StorageClass")));
            }
            bucketInfo.setBucket(bucket);
            String aclString = bucketElem.getChild("AccessControlList").getChildText("Grant");
            CannedAccessControlList acl = CannedAccessControlList.parse(aclString);
            bucketInfo.setCannedACL(acl);
            switch (acl) {
                case PublicRead: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.Read);
                    break;
                }
                case PublicReadWrite: {
                    bucketInfo.grantPermission(GroupGrantee.AllUsers, Permission.FullControl);
                    break;
                }
            }
            return bucketInfo;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static BucketStat parseGetBucketStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            Long storage = Long.parseLong(root.getChildText("Storage"));
            Long objectCount = Long.parseLong(root.getChildText("ObjectCount"));
            Long multipartUploadCount = Long.parseLong(root.getChildText("MultipartUploadCount"));
            BucketStat bucketStat = new BucketStat(storage, objectCount, multipartUploadCount);
            return bucketStat;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static CreateLiveChannelResult parseCreateLiveChannel(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            CreateLiveChannelResult result = new CreateLiveChannelResult();
            ArrayList<String> publishUrls = new ArrayList<String>();
            List publishElems = root.getChild("PublishUrls").getChildren("Url");
            for (Element urlElem : publishElems) {
                publishUrls.add(urlElem.getText());
            }
            result.setPublishUrls(publishUrls);
            ArrayList<String> playUrls = new ArrayList<String>();
            List playElems = root.getChild("PlayUrls").getChildren("Url");
            for (Element urlElem : playElems) {
                playUrls.add(urlElem.getText());
            }
            result.setPlayUrls(playUrls);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelInfo parseGetLiveChannelInfo(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelInfo result = new LiveChannelInfo();
            result.setDescription(root.getChildText("Description"));
            result.setStatus(LiveChannelStatus.parse(root.getChildText("Status")));
            Element targetElem = root.getChild("Target");
            LiveChannelTarget target = new LiveChannelTarget();
            target.setType(targetElem.getChildText("Type"));
            target.setFragDuration(Integer.parseInt(targetElem.getChildText("FragDuration")));
            target.setFragCount(Integer.parseInt(targetElem.getChildText("FragCount")));
            target.setPlaylistName(targetElem.getChildText("PlaylistName"));
            result.setTarget(target);
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelStat parseGetLiveChannelStat(InputStream responseBody) throws ResponseParseException {
        try {
            Element audioElem;
            Element videoElem;
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelStat result = new LiveChannelStat();
            result.setPushflowStatus(PushflowStatus.parse(root.getChildText("Status")));
            if (root.getChild("ConnectedTime") != null) {
                result.setConnectedDate(DateUtil.parseIso8601Date(root.getChildText("ConnectedTime")));
            }
            if (root.getChild("RemoteAddr") != null) {
                result.setRemoteAddress(root.getChildText("RemoteAddr"));
            }
            if ((videoElem = root.getChild("Video")) != null) {
                LiveChannelStat.VideoStat videoStat = new LiveChannelStat.VideoStat();
                videoStat.setWidth(Integer.parseInt(videoElem.getChildText("Width")));
                videoStat.setHeight(Integer.parseInt(videoElem.getChildText("Height")));
                videoStat.setFrameRate(Integer.parseInt(videoElem.getChildText("FrameRate")));
                videoStat.setBandWidth(Integer.parseInt(videoElem.getChildText("Bandwidth")));
                videoStat.setCodec(videoElem.getChildText("Codec"));
                result.setVideoStat(videoStat);
            }
            if ((audioElem = root.getChild("Audio")) != null) {
                LiveChannelStat.AudioStat audioStat = new LiveChannelStat.AudioStat();
                audioStat.setBandWidth(Integer.parseInt(audioElem.getChildText("Bandwidth")));
                audioStat.setSampleRate(Integer.parseInt(audioElem.getChildText("SampleRate")));
                audioStat.setCodec(audioElem.getChildText("Codec"));
                result.setAudioStat(audioStat);
            }
            return result;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LiveRecord> parseGetLiveChannelHistory(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LiveRecord> liveRecords = new ArrayList<LiveRecord>();
            List recordElements = root.getChildren("LiveRecord");
            for (Element recordElem : recordElements) {
                LiveRecord record = new LiveRecord();
                record.setStartDate(DateUtil.parseIso8601Date(recordElem.getChildText("StartTime")));
                record.setEndDate(DateUtil.parseIso8601Date(recordElem.getChildText("EndTime")));
                record.setRemoteAddress(recordElem.getChildText("RemoteAddr"));
                liveRecords.add(record);
            }
            return liveRecords;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static LiveChannelListing parseListLiveChannels(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            LiveChannelListing liveChannelListing = new LiveChannelListing();
            liveChannelListing.setTruncated(Boolean.valueOf(root.getChildText("IsTruncated")));
            if (root.getChild("Prefix") != null) {
                String prefix = root.getChildText("Prefix");
                liveChannelListing.setPrefix(CodingUtils.isNullOrEmpty(prefix) ? null : prefix);
            }
            if (root.getChild("Marker") != null) {
                String marker = root.getChildText("Marker");
                liveChannelListing.setMarker(CodingUtils.isNullOrEmpty(marker) ? null : marker);
            }
            if (root.getChild("MaxKeys") != null) {
                String maxKeys = root.getChildText("MaxKeys");
                liveChannelListing.setMaxKeys(Integer.valueOf(maxKeys));
            }
            if (root.getChild("NextMarker") != null) {
                String nextMarker = root.getChildText("NextMarker");
                liveChannelListing.setNextMarker(CodingUtils.isNullOrEmpty(nextMarker) ? null : nextMarker);
            }
            List liveChannelElems = root.getChildren("LiveChannel");
            for (Element elem : liveChannelElems) {
                LiveChannel liveChannel = new LiveChannel();
                liveChannel.setName(elem.getChildText("Name"));
                liveChannel.setDescription(elem.getChildText("Description"));
                liveChannel.setStatus(LiveChannelStatus.parse(elem.getChildText("Status")));
                liveChannel.setLastModified(DateUtil.parseIso8601Date(elem.getChildText("LastModified")));
                ArrayList<String> publishUrls = new ArrayList<String>();
                List publishElems = elem.getChild("PublishUrls").getChildren("Url");
                for (Element urlElem : publishElems) {
                    publishUrls.add(urlElem.getText());
                }
                liveChannel.setPublishUrls(publishUrls);
                ArrayList<String> playUrls = new ArrayList<String>();
                List playElems = elem.getChild("PlayUrls").getChildren("Url");
                for (Element urlElem : playElems) {
                    playUrls.add(urlElem.getText());
                }
                liveChannel.setPlayUrls(playUrls);
                liveChannelListing.addLiveChannel(liveChannel);
            }
            return liveChannelListing;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static UserQos parseGetUserQos(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            UserQos userQos = new UserQos();
            if (root.getChild("StorageCapacity") != null) {
                userQos.setStorageCapacity(Integer.parseInt(root.getChildText("StorageCapacity")));
            }
            return userQos;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<LifecycleRule> parseGetBucketLifecycle(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<LifecycleRule> lifecycleRules = new ArrayList<LifecycleRule>();
            List ruleElements = root.getChildren("Rule");
            for (Element ruleElem : ruleElements) {
                LifecycleRule rule = new LifecycleRule();
                if (ruleElem.getChild("ID") != null) {
                    rule.setId(ruleElem.getChildText("ID"));
                }
                if (ruleElem.getChild("Prefix") != null) {
                    rule.setPrefix(ruleElem.getChildText("Prefix"));
                }
                if (ruleElem.getChild("Status") != null) {
                    rule.setStatus(LifecycleRule.RuleStatus.valueOf(ruleElem.getChildText("Status")));
                }
                if (ruleElem.getChild("Expiration") != null) {
                    if (ruleElem.getChild("Expiration").getChild("Date") != null) {
                        Date expirationDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("Date"));
                        rule.setExpirationTime(expirationDate);
                    } else if (ruleElem.getChild("Expiration").getChild("Days") != null) {
                        rule.setExpirationDays(Integer.parseInt(ruleElem.getChild("Expiration").getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("Expiration").getChildText("CreatedBeforeDate"));
                        rule.setCreatedBeforeDate(createdBeforeDate);
                    }
                }
                if (ruleElem.getChild("AbortMultipartUpload") != null) {
                    LifecycleRule.AbortMultipartUpload abortMultipartUpload = new LifecycleRule.AbortMultipartUpload();
                    if (ruleElem.getChild("AbortMultipartUpload").getChild("Days") != null) {
                        abortMultipartUpload.setExpirationDays(Integer.parseInt(ruleElem.getChild("AbortMultipartUpload").getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(ruleElem.getChild("AbortMultipartUpload").getChildText("CreatedBeforeDate"));
                        abortMultipartUpload.setCreatedBeforeDate(createdBeforeDate);
                    }
                    rule.setAbortMultipartUpload(abortMultipartUpload);
                }
                List transitionElements = ruleElem.getChildren("Transition");
                ArrayList<LifecycleRule.StorageTransition> storageTransitions = new ArrayList<LifecycleRule.StorageTransition>();
                for (Element transitionElem : transitionElements) {
                    LifecycleRule.StorageTransition storageTransition = new LifecycleRule.StorageTransition();
                    if (transitionElem.getChild("Days") != null) {
                        storageTransition.setExpirationDays(Integer.parseInt(transitionElem.getChildText("Days")));
                    } else {
                        Date createdBeforeDate = DateUtil.parseIso8601Date(transitionElem.getChildText("CreatedBeforeDate"));
                        storageTransition.setCreatedBeforeDate(createdBeforeDate);
                    }
                    if (transitionElem.getChild("StorageClass") != null) {
                        storageTransition.setStorageClass(StorageClass.parse(transitionElem.getChildText("StorageClass")));
                    }
                    storageTransitions.add(storageTransition);
                }
                rule.setStorageTransition(storageTransitions);
                lifecycleRules.add(rule);
            }
            return lifecycleRules;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static List<CnameConfiguration> parseGetBucketCname(InputStream responseBody) throws ResponseParseException {
        try {
            Element root = ResponseParsers.getXmlRootElement(responseBody);
            ArrayList<CnameConfiguration> cnames = new ArrayList<CnameConfiguration>();
            List cnameElements = root.getChildren("Cname");
            for (Element cnameElem : cnameElements) {
                CnameConfiguration cname = new CnameConfiguration();
                cname.setDomain(cnameElem.getChildText("Domain"));
                cname.setStatus(CnameConfiguration.CnameStatus.valueOf(cnameElem.getChildText("Status")));
                cname.setLastMofiedTime(DateUtil.parseIso8601Date(cnameElem.getChildText("LastModified")));
                if (cnameElem.getChildText("IsPurgeCdnCache") != null) {
                    boolean purgeCdnCache = Boolean.valueOf(cnameElem.getChildText("IsPurgeCdnCache"));
                    cname.setPurgeCdnCache(purgeCdnCache);
                }
                cnames.add(cname);
            }
            return cnames;
        }
        catch (JDOMParseException e) {
            throw new ResponseParseException(e.getPartialDocument() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new ResponseParseException(e.getMessage(), e);
        }
    }

    public static final class ListUdfApplicationInfoResponseParser
    implements ResponseParser<List<UdfApplicationInfo>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<UdfApplicationInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<UdfApplicationInfo> list = ResponseParsers.parseListUdfApplicationInfo(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUdfApplicationInfoResponseParser
    implements ResponseParser<UdfApplicationInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UdfApplicationInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                UdfApplicationInfo result = ResponseParsers.parseGetUdfApplicationInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                UdfApplicationInfo udfApplicationInfo = result;
                return udfApplicationInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUdfImageInfoResponseParser
    implements ResponseParser<List<UdfImageInfo>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<UdfImageInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<UdfImageInfo> list = ResponseParsers.parseGetUdfImageInfo(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListUdfResponseParser
    implements ResponseParser<List<UdfInfo>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<UdfInfo> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<UdfInfo> list = ResponseParsers.parseListUdf(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUdfInfoResponseParser
    implements ResponseParser<UdfInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UdfInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                UdfInfo result = ResponseParsers.parseGetUdfInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                UdfInfo udfInfo = result;
                return udfInfo;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class GetSymbolicLinkResponseParser
    implements ResponseParser<OSSSymlink> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OSSSymlink parse(ResponseMessage response) throws ResponseParseException {
            try {
                OSSSymlink result = ResponseParsers.parseSymbolicLink(response);
                result.setRequestId(response.getRequestId());
                OSSSymlink oSSSymlink = result;
                return oSSSymlink;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class UploadPartCopyResponseParser
    implements ResponseParser<UploadPartCopyResult> {
        private int partNumber;

        public UploadPartCopyResponseParser(int partNumber) {
            this.partNumber = partNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UploadPartCopyResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                UploadPartCopyResult result = new UploadPartCopyResult();
                result.setPartNumber(this.partNumber);
                result.setETag(OSSUtils.trimQuotes(ResponseParsers.parseUploadPartCopy(response.getContent())));
                result.setRequestId(response.getRequestId());
                UploadPartCopyResult uploadPartCopyResult = result;
                return uploadPartCopyResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListPartsResponseParser
    implements ResponseParser<PartListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PartListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                PartListing result = ResponseParsers.parseListParts(response.getContent());
                result.setRequestId(response.getRequestId());
                PartListing partListing = result;
                return partListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListMultipartUploadsResponseParser
    implements ResponseParser<MultipartUploadListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MultipartUploadListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                MultipartUploadListing result = ResponseParsers.parseListMultipartUploads(response.getContent());
                result.setRequestId(response.getRequestId());
                MultipartUploadListing multipartUploadListing = result;
                return multipartUploadListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class InitiateMultipartUploadResponseParser
    implements ResponseParser<InitiateMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InitiateMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                InitiateMultipartUploadResult result = ResponseParsers.parseInitiateMultipartUpload(response.getContent());
                result.setRequestId(response.getRequestId());
                InitiateMultipartUploadResult initiateMultipartUploadResult = result;
                return initiateMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CompleteMultipartUploadProcessResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            CompleteMultipartUploadResult result = new CompleteMultipartUploadResult();
            result.setRequestId(response.getRequestId());
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class CompleteMultipartUploadResponseParser
    implements ResponseParser<CompleteMultipartUploadResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompleteMultipartUploadResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CompleteMultipartUploadResult result = ResponseParsers.parseCompleteMultipartUpload(response.getContent());
                result.setRequestId(response.getRequestId());
                ResponseParsers.setServerCRC(result, response);
                CompleteMultipartUploadResult completeMultipartUploadResult = result;
                return completeMultipartUploadResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class DeleteObjectsResponseParser
    implements ResponseParser<DeleteObjectsResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DeleteObjectsResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                DeleteObjectsResult result = null;
                result = response.getContentLength() == 0L ? new DeleteObjectsResult(null) : ResponseParsers.parseDeleteObjectsResult(response.getContent());
                result.setRequestId(response.getRequestId());
                DeleteObjectsResult deleteObjectsResult = result;
                return deleteObjectsResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CopyObjectResponseParser
    implements ResponseParser<CopyObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CopyObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CopyObjectResult result = ResponseParsers.parseCopyObjectResult(response.getContent());
                result.setRequestId(response.getRequestId());
                CopyObjectResult copyObjectResult = result;
                return copyObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class HeadObjectResponseParser
    implements ResponseParser<ObjectMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetObjectMetadataResponseParser
    implements ResponseParser<ObjectMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectMetadata objectMetadata = ResponseParsers.parseObjectMetadata(response.getHeaders());
                return objectMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ProcessObjectResponseParser
    implements ResponseParser<GenericResult> {
        @Override
        public GenericResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setResponse(response);
            return result;
        }
    }

    public static final class RestoreObjectResponseParser
    implements ResponseParser<RestoreObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RestoreObjectResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                RestoreObjectResult result = new RestoreObjectResult(response.getStatusCode());
                result.setRequestId(response.getRequestId());
                RestoreObjectResult restoreObjectResult = result;
                return restoreObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetSimplifiedObjectMetaResponseParser
    implements ResponseParser<SimplifiedObjectMeta> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimplifiedObjectMeta parse(ResponseMessage response) throws ResponseParseException {
            try {
                SimplifiedObjectMeta simplifiedObjectMeta = ResponseParsers.parseSimplifiedObjectMeta(response.getHeaders());
                return simplifiedObjectMeta;
            }
            finally {
                OSSUtils.mandatoryCloseResponse(response);
            }
        }
    }

    public static final class GetObjectAclResponseParser
    implements ResponseParser<ObjectAcl> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectAcl parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectAcl result = ResponseParsers.parseGetObjectAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                ObjectAcl objectAcl = result;
                return objectAcl;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetUdfApplicationLogResponseParser
    implements ResponseParser<UdfApplicationLog> {
        private String udfName;

        public GetUdfApplicationLogResponseParser(String udfName) {
            this.udfName = udfName;
        }

        @Override
        public UdfApplicationLog parse(ResponseMessage response) throws ResponseParseException {
            UdfApplicationLog appLog = new UdfApplicationLog(this.udfName);
            appLog.setLogContent(response.getContent());
            appLog.setRequestId(response.getRequestId());
            appLog.setResponse(response);
            ResponseParsers.setServerCRC(appLog, response);
            return appLog;
        }
    }

    public static final class GetObjectResponseParser
    implements ResponseParser<OSSObject> {
        private String bucketName;
        private String key;

        public GetObjectResponseParser(String bucketName, String key) {
            this.bucketName = bucketName;
            this.key = key;
        }

        @Override
        public OSSObject parse(ResponseMessage response) throws ResponseParseException {
            OSSObject ossObject = new OSSObject();
            ossObject.setBucketName(this.bucketName);
            ossObject.setKey(this.key);
            ossObject.setObjectContent(response.getContent());
            ossObject.setRequestId(response.getRequestId());
            ossObject.setResponse(response);
            try {
                ossObject.setObjectMetadata(ResponseParsers.parseObjectMetadata(response.getHeaders()));
                ResponseParsers.setServerCRC(ossObject, response);
                return ossObject;
            }
            catch (ResponseParseException e) {
                OSSUtils.safeCloseResponse(response);
                throw e;
            }
        }
    }

    public static final class AppendObjectResponseParser
    implements ResponseParser<AppendObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppendObjectResult parse(ResponseMessage response) throws ResponseParseException {
            AppendObjectResult result = new AppendObjectResult();
            result.setRequestId(response.getRequestId());
            try {
                String nextPosition = response.getHeaders().get("x-oss-next-append-position");
                if (nextPosition != null) {
                    result.setNextPosition(Long.valueOf(nextPosition));
                }
                result.setObjectCRC(response.getHeaders().get("x-oss-hash-crc64ecma"));
                ResponseParsers.setCRC(result, response);
                AppendObjectResult appendObjectResult = result;
                return appendObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class PutObjectProcessReponseParser
    implements ResponseParser<PutObjectResult> {
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            result.setRequestId(response.getRequestId());
            result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
            result.setCallbackResponseBody(response.getContent());
            result.setResponse(response);
            return result;
        }
    }

    public static final class PutObjectReponseParser
    implements ResponseParser<PutObjectResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PutObjectResult parse(ResponseMessage response) throws ResponseParseException {
            PutObjectResult result = new PutObjectResult();
            try {
                result.setETag(OSSUtils.trimQuotes(response.getHeaders().get("ETag")));
                result.setRequestId(response.getRequestId());
                ResponseParsers.setCRC(result, response);
                PutObjectResult putObjectResult = result;
                return putObjectResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListObjectsReponseParser
    implements ResponseParser<ObjectListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ObjectListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                ObjectListing result = ResponseParsers.parseListObjects(response.getContent());
                result.setRequestId(response.getRequestId());
                ObjectListing objectListing = result;
                return objectListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationLocationResponseParser
    implements ResponseParser<List<String>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<String> list = ResponseParsers.parseGetBucketReplicationLocation(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationProgressResponseParser
    implements ResponseParser<BucketReplicationProgress> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReplicationProgress parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReplicationProgress result = ResponseParsers.parseGetBucketReplicationProgress(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReplicationProgress bucketReplicationProgress = result;
                return bucketReplicationProgress;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketReplicationResponseParser
    implements ResponseParser<List<ReplicationRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ReplicationRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<ReplicationRule> list = ResponseParsers.parseGetBucketReplication(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketTaggingResponseParser
    implements ResponseParser<TagSet> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TagSet parse(ResponseMessage response) throws ResponseParseException {
            try {
                TagSet result = ResponseParsers.parseGetBucketTagging(response.getContent());
                result.setRequestId(response.getRequestId());
                TagSet tagSet = result;
                return tagSet;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCorsResponseParser
    implements ResponseParser<List<SetBucketCORSRequest.CORSRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<SetBucketCORSRequest.CORSRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<SetBucketCORSRequest.CORSRule> list = ResponseParsers.parseListBucketCORS(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListLiveChannelsReponseParser
    implements ResponseParser<LiveChannelListing> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelListing parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelListing liveChannelListing = ResponseParsers.parseListLiveChannels(response.getContent());
                return liveChannelListing;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelHistoryResponseParser
    implements ResponseParser<List<LiveRecord>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LiveRecord> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LiveRecord> list = ResponseParsers.parseGetLiveChannelHistory(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelStatResponseParser
    implements ResponseParser<LiveChannelStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelStat result = ResponseParsers.parseGetLiveChannelStat(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelStat liveChannelStat = result;
                return liveChannelStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetLiveChannelInfoResponseParser
    implements ResponseParser<LiveChannelInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LiveChannelInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                LiveChannelInfo result = ResponseParsers.parseGetLiveChannelInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                LiveChannelInfo liveChannelInfo = result;
                return liveChannelInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class CreateLiveChannelResponseParser
    implements ResponseParser<CreateLiveChannelResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CreateLiveChannelResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                CreateLiveChannelResult result = ResponseParsers.parseCreateLiveChannel(response.getContent());
                result.setRequestId(response.getRequestId());
                CreateLiveChannelResult createLiveChannelResult = result;
                return createLiveChannelResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketQosResponseParser
    implements ResponseParser<UserQos> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UserQos parse(ResponseMessage response) throws ResponseParseException {
            try {
                UserQos result = ResponseParsers.parseGetUserQos(response.getContent());
                result.setRequestId(response.getRequestId());
                UserQos userQos = result;
                return userQos;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketStatResponseParser
    implements ResponseParser<BucketStat> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketStat parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketStat result = ResponseParsers.parseGetBucketStat(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketStat bucketStat = result;
                return bucketStat;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketInfoResponseParser
    implements ResponseParser<BucketInfo> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketInfo parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketInfo result = ResponseParsers.parseGetBucketInfo(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketInfo bucketInfo = result;
                return bucketInfo;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketCnameResponseParser
    implements ResponseParser<List<CnameConfiguration>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CnameConfiguration> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<CnameConfiguration> list = ResponseParsers.parseGetBucketCname(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLifecycleResponseParser
    implements ResponseParser<List<LifecycleRule>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<LifecycleRule> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<LifecycleRule> list = ResponseParsers.parseGetBucketLifecycle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketWebsiteResponseParser
    implements ResponseParser<BucketWebsiteResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketWebsiteResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketWebsiteResult result = ResponseParsers.parseBucketWebsite(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketWebsiteResult bucketWebsiteResult = result;
                return bucketWebsiteResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageProcessConfResponseParser
    implements ResponseParser<BucketProcess> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketProcess parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketProcess result = ResponseParsers.parseGetBucketImageProcessConf(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketProcess bucketProcess = result;
                return bucketProcess;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetImageStyleResponseParser
    implements ResponseParser<GetImageStyleResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetImageStyleResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetImageStyleResult getImageStyleResult = ResponseParsers.parseImageStyle(response.getContent());
                return getImageStyleResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketImageResponseParser
    implements ResponseParser<GetBucketImageResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GetBucketImageResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                GetBucketImageResult getBucketImageResult = ResponseParsers.parseBucketImage(response.getContent());
                return getBucketImageResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLoggingResponseParser
    implements ResponseParser<BucketLoggingResult> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketLoggingResult parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketLoggingResult result = ResponseParsers.parseBucketLogging(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketLoggingResult bucketLoggingResult = result;
                return bucketLoggingResult;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketLocationResponseParser
    implements ResponseParser<String> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String parse(ResponseMessage response) throws ResponseParseException {
            try {
                String string = ResponseParsers.parseGetBucketLocation(response.getContent());
                return string;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketMetadataResponseParser
    implements ResponseParser<BucketMetadata> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketMetadata parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketMetadata bucketMetadata = ResponseParsers.parseBucketMetadata(response.getHeaders());
                return bucketMetadata;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketAclResponseParser
    implements ResponseParser<AccessControlList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessControlList parse(ResponseMessage response) throws ResponseParseException {
            try {
                AccessControlList result = ResponseParsers.parseGetBucketAcl(response.getContent());
                result.setRequestId(response.getRequestId());
                AccessControlList accessControlList = result;
                return accessControlList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class GetBucketRefererResponseParser
    implements ResponseParser<BucketReferer> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketReferer parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketReferer result = ResponseParsers.parseGetBucketReferer(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketReferer bucketReferer = result;
                return bucketReferer;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListImageStyleResponseParser
    implements ResponseParser<List<Style>> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Style> parse(ResponseMessage response) throws ResponseParseException {
            try {
                List<Style> list = ResponseParsers.parseListImageStyle(response.getContent());
                return list;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class ListBucketResponseParser
    implements ResponseParser<BucketList> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BucketList parse(ResponseMessage response) throws ResponseParseException {
            try {
                BucketList result = ResponseParsers.parseListBucket(response.getContent());
                result.setRequestId(response.getRequestId());
                BucketList bucketList = result;
                return bucketList;
            }
            finally {
                OSSUtils.safeCloseResponse(response);
            }
        }
    }

    public static final class EmptyResponseParser
    implements ResponseParser<ResponseMessage> {
        @Override
        public ResponseMessage parse(ResponseMessage response) throws ResponseParseException {
            OSSUtils.safeCloseResponse(response);
            return response;
        }
    }
}

