/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ResponseMessage;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParseException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.parser.ResponseParser;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.internal.OSSUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBResponseParser
implements ResponseParser<Object> {
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl", null);
    private Class<?> modelClass;
    private static HashMap<Object, JAXBContext> cachedContexts = new HashMap();

    public JAXBResponseParser(Class<?> modelClass) {
        assert (modelClass != null);
        this.modelClass = modelClass;
    }

    @Override
    public Object parse(ResponseMessage response) throws ResponseParseException {
        assert (response != null && response.getContent() != null);
        return this.getObject(response.getContent());
    }

    private Object getObject(InputStream responseContent) throws ResponseParseException {
        try {
            if (!cachedContexts.containsKey(this.modelClass)) {
                JAXBResponseParser.initJAXBContext(this.modelClass);
            }
            assert (cachedContexts.containsKey(this.modelClass));
            JAXBContext jc = cachedContexts.get(this.modelClass);
            Unmarshaller um = jc.createUnmarshaller();
            return um.unmarshal((Source)JAXBResponseParser.getSAXSource(responseContent));
        }
        catch (JAXBException e) {
            throw new ResponseParseException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", e.getMessage()), e);
        }
        catch (SAXException e) {
            throw new ResponseParseException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", e.getMessage()), e);
        }
        catch (ParserConfigurationException e) {
            throw new ResponseParseException(OSSUtils.COMMON_RESOURCE_MANAGER.getFormattedString("FailedToParseResponse", e.getMessage()), e);
        }
    }

    private static synchronized void initJAXBContext(Class<?> c) throws JAXBException {
        if (!cachedContexts.containsKey(c)) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{c});
            cachedContexts.put(c, jc);
        }
    }

    private static SAXSource getSAXSource(InputStream content) throws SAXException, ParserConfigurationException {
        SAXParser saxParser = saxParserFactory.newSAXParser();
        return new SAXSource(saxParser.getXMLReader(), new InputSource(content));
    }

    static {
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
    }
}

