/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.ServiceClient;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.comm.io.Releasable;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.utils.LogUtils;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

public class ChunkedInputStreamEntity
extends BasicHttpEntity {
    private boolean firstAttempt = true;
    private ReleasableInputStreamEntity notClosableRequestEntity;
    private InputStream content;

    public ChunkedInputStreamEntity(ServiceClient.Request request) {
        this.setChunked(true);
        long contentLength = -1L;
        try {
            String contentLengthString = request.getHeaders().get("Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException nfe) {
            LogUtils.logException("Unable to parse content length from request.", nfe);
        }
        String contentType = request.getHeaders().get("Content-Type");
        this.notClosableRequestEntity = new ReleasableInputStreamEntity(request.getContent(), contentLength);
        this.notClosableRequestEntity.setCloseDisabled(true);
        this.notClosableRequestEntity.setContentType(contentType);
        this.content = request.getContent();
        this.setContent(this.content);
        this.setContentType(contentType);
        this.setContentLength(contentLength);
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public boolean isRepeatable() {
        return this.content.markSupported() || this.notClosableRequestEntity.isRepeatable();
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.notClosableRequestEntity.writeTo(output);
    }

    public static class ReleasableInputStreamEntity
    extends AbstractHttpEntity
    implements Releasable {
        private final InputStream content;
        private final long length;
        private boolean closeDisabled;

        public ReleasableInputStreamEntity(InputStream instream) {
            this(instream, -1L);
        }

        public ReleasableInputStreamEntity(InputStream instream, long length) {
            this(instream, length, null);
        }

        public ReleasableInputStreamEntity(InputStream instream, ContentType contentType) {
            this(instream, -1L, contentType);
        }

        public ReleasableInputStreamEntity(InputStream instream, long length, ContentType contentType) {
            this.content = Args.notNull(instream, "Source input stream");
            this.length = length;
            if (contentType != null) {
                this.setContentType(contentType.toString());
            }
            this.closeDisabled = false;
        }

        @Override
        public boolean isRepeatable() {
            return this.content.markSupported();
        }

        @Override
        public long getContentLength() {
            return this.length;
        }

        @Override
        public InputStream getContent() throws IOException {
            return this.content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeTo(OutputStream outstream) throws IOException {
            block7: {
                Args.notNull(outstream, "Output stream");
                InputStream instream = this.content;
                try {
                    int l;
                    byte[] buffer = new byte[4096];
                    if (this.length < 0L) {
                        int l2;
                        while ((l2 = instream.read(buffer)) != -1) {
                            outstream.write(buffer, 0, l2);
                        }
                        break block7;
                    }
                    for (long remaining = this.length; remaining > 0L; remaining -= (long)l) {
                        l = instream.read(buffer, 0, (int)Math.min(4096L, remaining));
                        if (l == -1) {
                            break;
                        }
                        outstream.write(buffer, 0, l);
                    }
                }
                finally {
                    this.close();
                }
            }
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        public void close() {
            if (!this.closeDisabled) {
                this.doRelease();
            }
        }

        @Override
        public void release() {
            this.doRelease();
        }

        private void doRelease() {
            try {
                this.content.close();
            }
            catch (Exception ex) {
                LogUtils.logException("Unexpected io exception when trying to close input stream", ex);
            }
        }

        public boolean isCloseDisabled() {
            return this.closeDisabled;
        }

        public void setCloseDisabled(boolean closeDisabled) {
            this.closeDisabled = closeDisabled;
        }
    }
}

