/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.HttpCredentialsFetcher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.InstanceProfileCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpResponse;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class InstanceProfileCredentialsFetcher
extends HttpCredentialsFetcher {
    private static final String URL_IN_ECS_METADATA = "/latest/meta-data/ram/security-credentials/";
    private static final String metadataServiceHost = "100.100.100.200";
    private String roleName;

    public void setRoleName(String roleName) {
        if (null == roleName || roleName.isEmpty()) {
            throw new IllegalArgumentException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
    }

    public InstanceProfileCredentialsFetcher withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    @Override
    public URL buildUrl() throws ClientException {
        try {
            return new URL("http://100.100.100.200/latest/meta-data/ram/security-credentials/" + this.roleName);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public Credentials parse(HttpResponse response) throws ClientException {
        String jsonContent = new String(response.getHttpContent());
        try {
            JSONObject obj = new JSONObject(jsonContent);
            if (!(obj.has("Code") && obj.has("AccessKeyId") && obj.has("AccessKeySecret") && obj.has("SecurityToken") && obj.has("Expiration"))) {
                throw new ClientException("Invalid json got from ECS Metadata service.");
            }
            if (!"Success".equals(obj.getString("Code"))) {
                throw new ClientException("Failed to get RAM session credentials from ECS metadata service.");
            }
            return new InstanceProfileCredentials(obj.getString("AccessKeyId"), obj.getString("AccessKeySecret"), obj.getString("SecurityToken"), obj.getString("Expiration"));
        }
        catch (JSONException e) {
            throw new ClientException("InstanceProfileCredentialsFetcher.parse [" + jsonContent + "] exception:" + e);
        }
    }
}

