/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.BasicCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.Credentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.HttpCredentialsFetcher;
import org.apache.flink.fs.osshadoop.shaded.com.aliyun.oss.common.auth.InstanceProfileCredentials;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.exceptions.ClientException;
import org.apache.flink.fs.osshadoop.shaded.com.aliyuncs.http.HttpResponse;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class CustomSessionCredentialsFetcher
extends HttpCredentialsFetcher {
    private String ossAuthServerHost;

    public CustomSessionCredentialsFetcher(String ossAuthServerHost) {
        this.ossAuthServerHost = ossAuthServerHost;
    }

    @Override
    public URL buildUrl() throws ClientException {
        try {
            return new URL(this.ossAuthServerHost);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    @Override
    public Credentials parse(HttpResponse response) throws ClientException {
        String jsonContent = new String(response.getHttpContent());
        try {
            JSONObject jsonObject = new JSONObject(jsonContent);
            if (!jsonObject.has("StatusCode")) {
                throw new ClientException("Invalid json " + jsonContent + " got from oss auth server.");
            }
            if (!"200".equals(jsonObject.get("StatusCode"))) {
                throw new ClientException("Failed to get credentials from oss auth server");
            }
            if (!jsonObject.has("AccessKeyId") || !jsonObject.has("AccessKeySecret")) {
                throw new ClientException("Invalid json " + jsonContent + " got from oss auth server.");
            }
            String securityToken = null;
            if (jsonObject.has("SecurityToken")) {
                securityToken = jsonObject.getString("SecurityToken");
            }
            if (jsonObject.has("Expiration")) {
                return new InstanceProfileCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("AccessKeySecret"), securityToken, jsonObject.getString("Expiration")).withExpiredDuration(3600L);
            }
            return new BasicCredentials(jsonObject.getString("AccessKeyId"), jsonObject.getString("AccessKeySecret"), securityToken);
        }
        catch (JSONException e) {
            throw new ClientException("CustomSessionCredentialsFetcher.parse [" + jsonContent + "] exception:" + e);
        }
    }
}

