/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.data.Record;
import org.apache.flink.orc.util.OrcBulkWriterTestUtil;
import org.apache.flink.orc.vector.RecordVectorizer;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.UniqueBucketAssigner;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OrcBulkWriterTest {
    private final String schema = "struct<_col0:string,_col1:int>";
    private final List<Record> input = Arrays.asList(new Record("Shiv", 44), new Record("Jesse", 23), new Record("Walt", 50));

    OrcBulkWriterTest() {
    }

    @Test
    void testOrcBulkWriter(@TempDir File outDir) throws Exception {
        Properties writerProps = new Properties();
        writerProps.setProperty("orc.compress", "LZ4");
        OrcBulkWriterFactory writer = new OrcBulkWriterFactory((Vectorizer)new RecordVectorizer("struct<_col0:string,_col1:int>"), writerProps, new Configuration());
        StreamingFileSink sink = ((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)StreamingFileSink.forBulkFormat((Path)new Path(outDir.toURI()), (BulkWriter.Factory)writer).withBucketAssigner((BucketAssigner)new UniqueBucketAssigner("test"))).withBucketCheckInterval(10000L)).build();
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 1, 1, 0);){
            testHarness.setup();
            testHarness.open();
            int time = 0;
            for (Record record : this.input) {
                testHarness.processElement((Object)record, (long)(++time));
            }
            testHarness.snapshot(1L, (long)(++time));
            testHarness.notifyOfCompletedCheckpoint(1L);
            OrcBulkWriterTestUtil.validate(outDir, this.input);
        }
    }
}

