/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.connector.datagen.source.TestDataGenerators;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.data.Record;
import org.apache.flink.orc.util.OrcBulkWriterTestUtil;
import org.apache.flink.orc.vector.RecordVectorizer;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.UniqueBucketAssigner;
import org.apache.hadoop.conf.Configuration;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OrcBulkWriterITCase {
    private final String schema = "struct<_col0:string,_col1:int>";
    private final List<Record> testData = Arrays.asList(new Record("Sourav", 41), new Record("Saul", 35), new Record("Kim", 31));

    OrcBulkWriterITCase() {
    }

    @Test
    void testOrcBulkWriter(@TempDir File outDir) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Properties writerProps = new Properties();
        writerProps.setProperty("orc.compress", "LZ4");
        OrcBulkWriterFactory factory = new OrcBulkWriterFactory((Vectorizer)new RecordVectorizer("struct<_col0:string,_col1:int>"), writerProps, new Configuration());
        env.setParallelism(1);
        env.enableCheckpointing(100L);
        DataStreamSource stream = env.fromSource((Source)TestDataGenerators.fromDataWithSnapshotsLatch(this.testData, (TypeInformation)TypeInformation.of(Record.class)), WatermarkStrategy.noWatermarks(), "Test Source");
        stream.map((MapFunction & Serializable)str -> str).addSink((SinkFunction)((StreamingFileSink.DefaultBulkFormatBuilder)StreamingFileSink.forBulkFormat((Path)new Path(outDir.toURI()), (BulkWriter.Factory)factory).withBucketAssigner((BucketAssigner)new UniqueBucketAssigner("test"))).build());
        env.execute();
        OrcBulkWriterTestUtil.validate(outDir, this.testData);
    }
}

