/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.local.LocalDataOutputStream;
import org.apache.flink.orc.data.Record;
import org.apache.flink.orc.vector.RecordVectorizer;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.Path;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcFile;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OrcBulkWriterFactoryTest {
    OrcBulkWriterFactoryTest() {
    }

    @Test
    void testNotOverrideInMemoryManager(@TempDir java.nio.file.Path tmpDir) throws IOException {
        TestMemoryManager memoryManager = new TestMemoryManager();
        TestOrcBulkWriterFactory<Record> factory = new TestOrcBulkWriterFactory<Record>(new RecordVectorizer("struct<_col0:string,_col1:int>"), memoryManager);
        factory.create((FSDataOutputStream)new LocalDataOutputStream(tmpDir.resolve("file1").toFile()));
        factory.create((FSDataOutputStream)new LocalDataOutputStream(tmpDir.resolve("file2").toFile()));
        List<Path> addedWriterPath = memoryManager.getAddedWriterPath();
        Assertions.assertThat(addedWriterPath).hasSize(2);
        Assertions.assertThat((Comparable)((Comparable)addedWriterPath.get(1))).isNotEqualTo((Object)addedWriterPath.get(0));
    }

    private static class TestMemoryManager
    implements MemoryManager {
        private final List<Path> addedWriterPath = new ArrayList<Path>();

        private TestMemoryManager() {
        }

        public void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) {
            this.addedWriterPath.add(path);
        }

        public List<Path> getAddedWriterPath() {
            return this.addedWriterPath;
        }

        public void removeWriter(Path path) {
        }

        public void addedRow(int rows) {
        }
    }

    private static class TestOrcBulkWriterFactory<T>
    extends OrcBulkWriterFactory<T> {
        private final MemoryManager memoryManager;

        public TestOrcBulkWriterFactory(Vectorizer<T> vectorizer, MemoryManager memoryManager) {
            super(vectorizer);
            this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memoryManager);
        }

        protected OrcFile.WriterOptions getWriterOptions() {
            OrcFile.WriterOptions options = super.getWriterOptions();
            options.memory(this.memoryManager);
            return options;
        }
    }
}

