/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.CheckpointedPosition;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.connector.file.src.util.Utils;
import org.apache.flink.connector.file.table.PartitionFieldExtractor;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcColumnarRowInputFormat;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OrcColumnarRowInputFormatTest {
    protected static final int BATCH_SIZE = 9;
    private static final RowType FLAT_FILE_TYPE = RowType.of((LogicalType[])new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType()}, (String[])new String[]{"_col0", "_col1", "_col2", "_col3", "_col4", "_col5", "_col6", "_col7", "_col8"});
    private static final RowType DECIMAL_FILE_TYPE = RowType.of((LogicalType[])new LogicalType[]{new DecimalType(10, 5)}, (String[])new String[]{"_col0"});
    private static Path flatFile;
    private static Path decimalFile;

    OrcColumnarRowInputFormatTest() {
    }

    @BeforeAll
    static void setupFiles(@TempDir java.nio.file.Path tmpDir) {
        flatFile = OrcColumnarRowInputFormatTest.copyFileFromResource("test-data-flat.orc", tmpDir.resolve("test-data-flat.orc"));
        decimalFile = OrcColumnarRowInputFormatTest.copyFileFromResource("test-data-decimal.orc", tmpDir.resolve("test-data-decimal.orc"));
    }

    @Test
    void testReadFileInSplits() throws IOException {
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createFormat(FLAT_FILE_TYPE, new int[]{0, 1});
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicLong totalF0 = new AtomicLong(0L);
        for (FileSourceSplit split : OrcColumnarRowInputFormatTest.createSplits(flatFile, 4)) {
            this.forEach(format, split, row -> {
                Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                totalF0.addAndGet(row.getInt(0));
                Assertions.assertThat((String)row.getString(1).toString()).isNotNull();
                cnt.incrementAndGet();
            });
        }
        Assertions.assertThat((int)cnt.get()).isEqualTo(1920800);
        Assertions.assertThat((long)totalF0.get()).isEqualTo(1844737280400L);
    }

    @Test
    void testReadFileWithSelectFields() throws IOException {
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createFormat(FLAT_FILE_TYPE, new int[]{2, 0, 1});
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicLong totalF0 = new AtomicLong(0L);
        for (FileSourceSplit split : OrcColumnarRowInputFormatTest.createSplits(flatFile, 4)) {
            this.forEach(format, split, row -> {
                Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(2)).isFalse();
                Assertions.assertThat((String)row.getString(0).toString()).isNotNull();
                totalF0.addAndGet(row.getInt(1));
                Assertions.assertThat((String)row.getString(2).toString()).isNotNull();
                cnt.incrementAndGet();
            });
        }
        Assertions.assertThat((int)cnt.get()).isEqualTo(1920800);
        Assertions.assertThat((long)totalF0.get()).isEqualTo(1844737280400L);
    }

    @Test
    void testReadDecimalTypeFile() throws IOException {
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createFormat(DECIMAL_FILE_TYPE, new int[]{0});
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicInteger nullCount = new AtomicInteger(0);
        for (FileSourceSplit split : OrcColumnarRowInputFormatTest.createSplits(decimalFile, 4)) {
            this.forEach(format, split, row -> {
                if (cnt.get() == 0) {
                    Assertions.assertThat((Object)row).isNotNull();
                    Assertions.assertThat((int)row.getArity()).isEqualTo(1);
                    Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isEqualTo((Object)DecimalDataUtils.castFrom((double)-1000.5, (int)10, (int)5));
                } else if (!row.isNullAt(0)) {
                    Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isNotNull();
                } else {
                    nullCount.incrementAndGet();
                }
                cnt.incrementAndGet();
            });
        }
        Assertions.assertThat((int)cnt.get()).isEqualTo(6000);
        Assertions.assertThat((int)nullCount.get()).isEqualTo(2000);
    }

    @Test
    void testReadFileWithPartitionFields(@TempDir java.nio.file.Path tmpDir) throws IOException {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        partSpec.put("f1", "1");
        partSpec.put("f3", "3");
        partSpec.put("f5", "f5");
        partSpec.put("f8", BigDecimal.valueOf(5.333).toString());
        partSpec.put("f13", "f13");
        Path flatFile = OrcColumnarRowInputFormatTest.copyFileFromResource("test-data-flat.orc", tmpDir.resolve(PartitionPathUtils.generatePartitionPath(partSpec)));
        RowType tableType = RowType.of((LogicalType[])new LogicalType[]{DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.BIGINT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.DECIMAL((int)10, (int)5).getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), DataTypes.STRING().getLogicalType(), DataTypes.INT().getLogicalType()});
        int[] projectedFields = new int[]{8, 1, 3, 0, 5, 2};
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createPartitionFormat(tableType, new ArrayList<String>(partSpec.keySet()), projectedFields);
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicLong totalF0 = new AtomicLong(0L);
        for (FileSourceSplit split : OrcColumnarRowInputFormatTest.createSplits(flatFile, 4)) {
            this.forEach(format, split, row -> {
                Assertions.assertThat((boolean)row.isNullAt(3)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(5)).isFalse();
                totalF0.addAndGet(row.getInt(3));
                Assertions.assertThat((String)row.getString(5).toString()).isNotNull();
                Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(2)).isFalse();
                Assertions.assertThat((boolean)row.isNullAt(4)).isFalse();
                Assertions.assertThat((Comparable)row.getDecimal(0, 10, 5)).isEqualTo((Object)DecimalDataUtils.castFrom((double)5.333, (int)10, (int)5));
                Assertions.assertThat((int)row.getInt(1)).isEqualTo(1);
                Assertions.assertThat((long)row.getLong(2)).isEqualTo(3L);
                Assertions.assertThat((String)row.getString(4).toString()).isEqualTo("f5");
                cnt.incrementAndGet();
            });
        }
        Assertions.assertThat((int)cnt.get()).isEqualTo(1920800);
        Assertions.assertThat((long)totalF0.get()).isEqualTo(1844737280400L);
    }

    @Test
    void testReadFileAndRestore() throws IOException {
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createFormat(FLAT_FILE_TYPE, new int[]{0, 1});
        FileSourceSplit split = OrcColumnarRowInputFormatTest.createSplits(flatFile, 3).get(1);
        int expectedCnt = 660000;
        this.innerTestRestore(format, split, expectedCnt / 2, expectedCnt, 656700330000L);
    }

    @Test
    void testReadFileAndRestoreWithFilter() throws IOException {
        List<OrcFilters.Or> filter = Collections.singletonList(new OrcFilters.Or(new OrcFilters.Predicate[]{new OrcFilters.Between("_col0", PredicateLeaf.Type.LONG, (Serializable)Long.valueOf(0L), (Serializable)Long.valueOf(975000L)), new OrcFilters.Equals("_col0", PredicateLeaf.Type.LONG, (Serializable)Long.valueOf(980001L)), new OrcFilters.Between("_col0", PredicateLeaf.Type.LONG, (Serializable)Long.valueOf(990000L), (Serializable)Long.valueOf(1800000L))}));
        OrcColumnarRowInputFormat<?, FileSourceSplit> format = this.createFormat(FLAT_FILE_TYPE, new int[]{0, 1}, filter);
        FileSourceSplit split = OrcColumnarRowInputFormatTest.createSplits(flatFile, 1).get(0);
        int breakCnt = 975001;
        int expectedCnt = 1795000;
        long expectedTotalF0 = 1615113397500L;
        this.innerTestRestore(format, split, breakCnt, expectedCnt, expectedTotalF0);
    }

    private void innerTestRestore(OrcColumnarRowInputFormat<?, FileSourceSplit> format, FileSourceSplit split, int breakCnt, int expectedCnt, long expectedTotalF0) throws IOException {
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicLong totalF0 = new AtomicLong(0L);
        Consumer<RowData> consumer = row -> {
            Assertions.assertThat((boolean)row.isNullAt(0)).isFalse();
            Assertions.assertThat((boolean)row.isNullAt(1)).isFalse();
            totalF0.addAndGet(row.getInt(0));
            Assertions.assertThat((String)row.getString(1).toString()).isNotNull();
            cnt.incrementAndGet();
        };
        long offset = -1L;
        long recordSkipCount = -1L;
        try (BulkFormat.Reader<RowData> reader = this.createReader(format, split);){
            while (cnt.get() < breakCnt) {
                RecordAndPosition record;
                BulkFormat.RecordIterator batch = reader.readBatch();
                Assertions.assertThat((Object)batch).isNotNull();
                while ((record = batch.next()) != null && cnt.get() < breakCnt) {
                    consumer.accept((RowData)record.getRecord());
                    offset = record.getOffset();
                    recordSkipCount = record.getRecordSkipCount();
                }
                batch.releaseBatch();
            }
        }
        Utils.forEachRemaining(this.restoreReader(format, split, offset, recordSkipCount), consumer);
        Assertions.assertThat((int)cnt.get()).isEqualTo(expectedCnt);
        Assertions.assertThat((long)totalF0.get()).isEqualTo(expectedTotalF0);
    }

    protected OrcColumnarRowInputFormat<?, FileSourceSplit> createFormat(RowType formatType, int[] selectedFields) {
        return this.createFormat(formatType, selectedFields, new ArrayList<OrcFilters.Predicate>());
    }

    protected OrcColumnarRowInputFormat<?, FileSourceSplit> createFormat(RowType formatType, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates) {
        return OrcColumnarRowInputFormat.createPartitionedFormat((OrcShim)OrcShim.defaultShim(), (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration(), (RowType)formatType, new ArrayList(), (PartitionFieldExtractor)PartitionFieldExtractor.forFileSystem((String)""), (int[])selectedFields, conjunctPredicates, (int)9, InternalTypeInfo::of);
    }

    protected OrcColumnarRowInputFormat<?, FileSourceSplit> createPartitionFormat(RowType tableType, List<String> partitionKeys, int[] selectedFields) {
        return OrcColumnarRowInputFormat.createPartitionedFormat((OrcShim)OrcShim.defaultShim(), (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration(), (RowType)tableType, partitionKeys, (PartitionFieldExtractor)PartitionFieldExtractor.forFileSystem((String)""), (int[])selectedFields, new ArrayList(), (int)9, InternalTypeInfo::of);
    }

    private BulkFormat.Reader<RowData> createReader(OrcColumnarRowInputFormat<?, FileSourceSplit> format, FileSourceSplit split) throws IOException {
        return format.createReader(new Configuration(), split);
    }

    private BulkFormat.Reader<RowData> restoreReader(OrcColumnarRowInputFormat<?, FileSourceSplit> format, FileSourceSplit split, long offset, long recordSkipCount) throws IOException {
        FileSourceSplit restoreSplit = split.updateWithCheckpointedPosition(new CheckpointedPosition(offset, recordSkipCount));
        return format.restoreReader(new Configuration(), restoreSplit);
    }

    private void forEach(OrcColumnarRowInputFormat<?, FileSourceSplit> format, FileSourceSplit split, Consumer<RowData> action) throws IOException {
        Utils.forEachRemaining(this.createReader(format, split), action);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Path copyFileFromResource(String resourceName, java.nio.file.Path file) {
        try (InputStream resource = OrcColumnarRowInputFormatTest.class.getClassLoader().getResource(resourceName).openStream();){
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.copy(resource, file, new CopyOption[0]);
            Path path = new Path(file.toString());
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<FileSourceSplit> createSplits(Path path, int minNumSplits) throws IOException {
        long splitLen;
        ArrayList<FileSourceSplit> splits = new ArrayList<FileSourceSplit>(minNumSplits);
        FileStatus fileStatus = path.getFileSystem().getFileStatus(path);
        long len = fileStatus.getLen();
        long preferSplitSize = len / (long)minNumSplits + (long)(len % (long)minNumSplits == 0L ? 0 : 1);
        int splitNum = 0;
        for (long position = 0L; position < len; position += splitLen) {
            splitLen = Math.min(preferSplitSize, len - position);
            splits.add(new FileSourceSplit(String.valueOf(splitNum++), path, position, splitLen, fileStatus.getModificationTime(), len));
        }
        return splits;
    }
}

