/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.writer;

import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.vector.RowDataVectorizer;
import org.apache.flink.orc.vector.Vectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.functions.sink.filesystem.bucketassigners.UniqueBucketAssigner;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.CompressionKind;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class OrcBulkRowDataWriterTest {
    private final String schema = "struct<_col0:string,_col1:int,_col2:array<struct<_col2_col0:string>>,_col3:map<string,struct<_col3_col0:string,_col3_col1:timestamp>>>";
    private LogicalType[] fieldTypes;
    private List<RowData> input;

    OrcBulkRowDataWriterTest() {
    }

    @Test
    void testOrcBulkWriterWithRowData(@TempDir File outDir) throws Exception {
        Properties writerProps = new Properties();
        writerProps.setProperty("orc.compress", "LZ4");
        OrcBulkWriterFactory writer = new OrcBulkWriterFactory((Vectorizer)new RowDataVectorizer("struct<_col0:string,_col1:int,_col2:array<struct<_col2_col0:string>>,_col3:map<string,struct<_col3_col0:string,_col3_col1:timestamp>>>", this.fieldTypes), writerProps, new Configuration());
        StreamingFileSink sink = ((StreamingFileSink.DefaultBulkFormatBuilder)((StreamingFileSink.DefaultBulkFormatBuilder)StreamingFileSink.forBulkFormat((Path)new Path(outDir.toURI()), (BulkWriter.Factory)writer).withBucketAssigner((BucketAssigner)new UniqueBucketAssigner("test"))).withBucketCheckInterval(10000L)).build();
        try (OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)new StreamSink((SinkFunction)sink), 1, 1, 0);){
            testHarness.setup();
            testHarness.open();
            int time = 0;
            for (RowData record : this.input) {
                testHarness.processElement((Object)record, (long)(++time));
            }
            testHarness.snapshot(1L, (long)(++time));
            testHarness.notifyOfCompletedCheckpoint(1L);
            this.validate(outDir, this.input);
        }
    }

    @BeforeEach
    void initInput() {
        this.input = new ArrayList<RowData>();
        this.fieldTypes = new LogicalType[4];
        this.fieldTypes[0] = new VarCharType();
        this.fieldTypes[1] = new IntType();
        List<RowType.RowField> arrayRowFieldList = Collections.singletonList(new RowType.RowField("_col2_col0", (LogicalType)new VarCharType()));
        this.fieldTypes[2] = new ArrayType((LogicalType)new RowType(arrayRowFieldList));
        List<RowType.RowField> mapRowFieldList = Arrays.asList(new RowType.RowField("_col3_col0", (LogicalType)new VarCharType()), new RowType.RowField("_col3_col1", (LogicalType)new TimestampType()));
        this.fieldTypes[3] = new MapType((LogicalType)new VarCharType(), (LogicalType)new RowType(mapRowFieldList));
        GenericRowData rowData = new GenericRowData(4);
        rowData.setField(0, (Object)new BinaryStringData("_col_0_string_1"));
        rowData.setField(1, (Object)1);
        GenericRowData arrayValue1 = new GenericRowData(1);
        arrayValue1.setField(0, (Object)new BinaryStringData("_col_2_row_0_string_1"));
        GenericRowData arrayValue2 = new GenericRowData(1);
        arrayValue2.setField(0, (Object)new BinaryStringData("_col_2_row_1_string_1"));
        GenericArrayData arrayData = new GenericArrayData(new Object[]{arrayValue1, arrayValue2});
        rowData.setField(2, (Object)arrayData);
        GenericRowData mapValue1 = new GenericRowData(2);
        mapValue1.setField(0, (Object)new BinaryStringData("_col_3_map_value_string_1"));
        mapValue1.setField(1, (Object)TimestampData.fromTimestamp((Timestamp)new Timestamp(3600000L)));
        HashMap<BinaryStringData, GenericRowData> mapDataMap = new HashMap<BinaryStringData, GenericRowData>();
        mapDataMap.put(new BinaryStringData("_col_3_map_key_1"), mapValue1);
        GenericMapData mapData = new GenericMapData(mapDataMap);
        rowData.setField(3, (Object)mapData);
        this.input.add((RowData)rowData);
        rowData = new GenericRowData(4);
        rowData.setField(0, (Object)new BinaryStringData("_col_0_string_2"));
        rowData.setField(1, (Object)2);
        arrayValue1 = new GenericRowData(1);
        arrayValue1.setField(0, (Object)new BinaryStringData("_col_2_row_0_string_2"));
        arrayValue2 = new GenericRowData(1);
        arrayValue2.setField(0, (Object)new BinaryStringData("_col_2_row_1_string_2"));
        arrayData = new GenericArrayData(new Object[]{arrayValue1, arrayValue2});
        rowData.setField(2, (Object)arrayData);
        mapValue1 = new GenericRowData(2);
        mapValue1.setField(0, (Object)new BinaryStringData("_col_3_map_value_string_2"));
        mapValue1.setField(1, (Object)TimestampData.fromTimestamp((Timestamp)new Timestamp(3600000L)));
        mapDataMap = new HashMap();
        mapDataMap.put(new BinaryStringData("_col_3_map_key_2"), mapValue1);
        mapData = new GenericMapData(mapDataMap);
        rowData.setField(3, (Object)mapData);
        this.input.add((RowData)rowData);
    }

    private void validate(File files, List<RowData> expected) throws IOException {
        Object[] buckets = files.listFiles();
        Assertions.assertThat((Object[])buckets).hasSize(1);
        Object[] partFiles = ((File)buckets[0]).listFiles();
        Assertions.assertThat((Object[])partFiles).isNotNull();
        for (Object partFile : partFiles) {
            Assertions.assertThat((long)((File)partFile).length()).isGreaterThan(0L);
            OrcFile.ReaderOptions readerOptions = OrcFile.readerOptions((Configuration)new Configuration());
            Reader reader = OrcFile.createReader((org.apache.hadoop.fs.Path)new org.apache.hadoop.fs.Path(((File)partFile).toURI()), (OrcFile.ReaderOptions)readerOptions);
            Assertions.assertThat((long)reader.getNumberOfRows()).isEqualTo(2L);
            Assertions.assertThat((List)reader.getSchema().getFieldNames()).hasSize(4);
            Assertions.assertThat((Comparable)reader.getCompressionKind()).isSameAs((Object)CompressionKind.LZ4);
            List<RowData> results = OrcBulkRowDataWriterTest.getResults(reader);
            ((ListAssert)Assertions.assertThat(results).hasSize(2)).isEqualTo(expected);
        }
    }

    private static List<RowData> getResults(Reader reader) throws IOException {
        ArrayList<RowData> results = new ArrayList<RowData>();
        RecordReader recordReader = reader.rows();
        VectorizedRowBatch batch = reader.getSchema().createRowBatch();
        while (recordReader.nextBatch(batch)) {
            BytesColumnVector stringVector = (BytesColumnVector)batch.cols[0];
            LongColumnVector intVector = (LongColumnVector)batch.cols[1];
            ListColumnVector listVector = (ListColumnVector)batch.cols[2];
            MapColumnVector mapVector = (MapColumnVector)batch.cols[3];
            for (int r = 0; r < batch.size; ++r) {
                GenericRowData readRowData = new GenericRowData(4);
                readRowData.setField(0, (Object)OrcBulkRowDataWriterTest.readStringData(stringVector, r));
                readRowData.setField(1, (Object)OrcBulkRowDataWriterTest.readInt(intVector, r));
                readRowData.setField(2, (Object)OrcBulkRowDataWriterTest.readList(listVector, r));
                readRowData.setField(3, (Object)OrcBulkRowDataWriterTest.readMap(mapVector, r));
                results.add((RowData)readRowData);
            }
            recordReader.close();
        }
        return results;
    }

    private static StringData readStringData(BytesColumnVector stringVector, int row) {
        return new BinaryStringData(new String(stringVector.vector[row], stringVector.start[row], stringVector.length[row]));
    }

    private static int readInt(LongColumnVector intVector, int row) {
        return (int)intVector.vector[row];
    }

    private static ArrayData readList(ListColumnVector listVector, int row) {
        int offset = (int)listVector.offsets[row];
        StructColumnVector structChild = (StructColumnVector)listVector.child;
        BytesColumnVector valueChild = (BytesColumnVector)structChild.fields[0];
        StringData value1 = OrcBulkRowDataWriterTest.readStringData(valueChild, offset);
        GenericRowData arrayValue1 = new GenericRowData(1);
        arrayValue1.setField(0, (Object)value1);
        StringData value2 = OrcBulkRowDataWriterTest.readStringData(valueChild, offset + 1);
        GenericRowData arrayValue2 = new GenericRowData(1);
        arrayValue2.setField(0, (Object)value2);
        return new GenericArrayData(new Object[]{arrayValue1, arrayValue2});
    }

    private static MapData readMap(MapColumnVector mapVector, int row) {
        int offset = (int)mapVector.offsets[row];
        StringData keyData = OrcBulkRowDataWriterTest.readStringData((BytesColumnVector)mapVector.keys, offset);
        GenericRowData valueData = new GenericRowData(2);
        StructColumnVector structVector = (StructColumnVector)mapVector.values;
        BytesColumnVector bytesVector = (BytesColumnVector)structVector.fields[0];
        TimestampColumnVector timestampVector = (TimestampColumnVector)structVector.fields[1];
        StringData strValueData = OrcBulkRowDataWriterTest.readStringData(bytesVector, offset);
        TimestampData timestampData = OrcBulkRowDataWriterTest.readTimestamp(timestampVector, offset);
        valueData.setField(0, (Object)strValueData);
        valueData.setField(1, (Object)timestampData);
        HashMap<StringData, GenericRowData> mapDataMap = new HashMap<StringData, GenericRowData>();
        mapDataMap.put(keyData, valueData);
        return new GenericMapData(mapDataMap);
    }

    private static TimestampData readTimestamp(TimestampColumnVector timestampVector, int row) {
        return TimestampData.fromTimestamp((Timestamp)timestampVector.asScratchTimestamp(row));
    }
}

