/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.BulkIterationBase;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.Optimizer;
import org.apache.flink.optimizer.costs.CostEstimator;
import org.apache.flink.optimizer.costs.DefaultCostEstimator;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.util.OperatorResolver;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.Visitor;
import org.junit.Before;

public abstract class CompilerTestBase
extends TestLogger
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String IN_FILE = OperatingSystem.isWindows() ? "file:/c:/" : "file:///dev/random";
    protected static final String OUT_FILE = OperatingSystem.isWindows() ? "file:/c:/" : "file:///dev/null";
    protected static final int DEFAULT_PARALLELISM = 8;
    protected static final String DEFAULT_PARALLELISM_STRING = String.valueOf(8);
    private static final String CACHE_KEY = "cachekey";
    protected transient DataStatistics dataStats;
    protected transient Optimizer withStatsCompiler;
    protected transient Optimizer noStatsCompiler;
    private transient int statCounter;

    @Before
    public void setup() {
        Configuration flinkConf = new Configuration();
        this.dataStats = new DataStatistics();
        this.withStatsCompiler = new Optimizer(this.dataStats, (CostEstimator)new DefaultCostEstimator(), flinkConf);
        this.withStatsCompiler.setDefaultParallelism(8);
        this.noStatsCompiler = new Optimizer(null, (CostEstimator)new DefaultCostEstimator(), flinkConf);
        this.noStatsCompiler.setDefaultParallelism(8);
    }

    public OptimizedPlan compileWithStats(Plan p) {
        return this.withStatsCompiler.compile(p);
    }

    public OptimizedPlan compileNoStats(Plan p) {
        return this.noStatsCompiler.compile(p);
    }

    public static OperatorResolver getContractResolver(Plan plan) {
        return new OperatorResolver(plan);
    }

    public void setSourceStatistics(GenericDataSourceBase<?, ?> source, long size, float recordWidth) {
        this.setSourceStatistics(source, new FileInputFormat.FileBaseStatistics(Long.MAX_VALUE, size, recordWidth));
    }

    public void setSourceStatistics(GenericDataSourceBase<?, ?> source, FileInputFormat.FileBaseStatistics stats) {
        String key = CACHE_KEY + this.statCounter++;
        this.dataStats.cacheBaseStatistics((BaseStatistics)stats, key);
        source.setStatisticsKey(key);
    }

    public static OptimizerPlanNodeResolver getOptimizerPlanNodeResolver(OptimizedPlan plan) {
        return new OptimizerPlanNodeResolver(plan);
    }

    public static class SourceCollectorVisitor
    implements Visitor<Operator<?>> {
        protected final List<GenericDataSourceBase<?, ?>> sources = new ArrayList(4);

        public boolean preVisit(Operator<?> visitable) {
            if (visitable instanceof GenericDataSourceBase) {
                this.sources.add((GenericDataSourceBase)visitable);
            } else if (visitable instanceof BulkIterationBase) {
                ((BulkIterationBase)visitable).getNextPartialSolution().accept((Visitor)this);
            }
            return true;
        }

        public void postVisit(Operator<?> visitable) {
        }

        public List<GenericDataSourceBase<?, ?>> getSources() {
            return this.sources;
        }
    }

    public static final class OptimizerPlanNodeResolver {
        private final Map<String, ArrayList<PlanNode>> map;

        public OptimizerPlanNodeResolver(OptimizedPlan p) {
            HashMap<String, ArrayList<PlanNode>> map = new HashMap<String, ArrayList<PlanNode>>();
            for (PlanNode n : p.getAllNodes()) {
                Operator c = n.getOriginalOptimizerNode().getOperator();
                String name = c.getName();
                ArrayList<Object> list = map.get(name);
                if (list == null) {
                    list = new ArrayList(2);
                    map.put(name, list);
                }
                boolean shouldAdd = true;
                Iterator<PlanNode> iter = list.iterator();
                while (iter.hasNext()) {
                    PlanNode in = iter.next();
                    if (in.getOriginalOptimizerNode().getOperator() != c) continue;
                    if (in instanceof SingleInputPlanNode && n instanceof SingleInputPlanNode) {
                        SingleInputPlanNode thisNode = (SingleInputPlanNode)n;
                        SingleInputPlanNode otherNode = (SingleInputPlanNode)in;
                        if (thisNode.getPredecessor() == otherNode) {
                            iter.remove();
                            continue;
                        }
                        if (otherNode.getPredecessor() != thisNode) continue;
                        shouldAdd = false;
                        continue;
                    }
                    throw new RuntimeException("Unrecodnized case in test.");
                }
                if (!shouldAdd) continue;
                list.add(n);
            }
            this.map = map;
        }

        public <T extends PlanNode> T getNode(String name) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name.");
            }
            if (nodes.size() != 1) {
                throw new RuntimeException("Multiple nodes found with the given name.");
            }
            return (T)((PlanNode)nodes.get(0));
        }

        public <T extends PlanNode> T getNode(String name, Class<? extends Function> stubClass) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            PlanNode found = null;
            for (PlanNode node : nodes) {
                if (node.getClass() != stubClass) continue;
                if (found == null) {
                    found = node;
                    continue;
                }
                throw new RuntimeException("Multiple nodes found with the given name and stub class.");
            }
            if (found == null) {
                throw new RuntimeException("No node found with the given name and stub class.");
            }
            return (T)found;
        }

        public List<PlanNode> getNodes(String name) {
            List nodes = this.map.get(name);
            if (nodes == null || nodes.isEmpty()) {
                throw new RuntimeException("No node found with the given name.");
            }
            return new ArrayList<PlanNode>(nodes);
        }
    }
}

