/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.plan;

import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.operators.GenericDataSourceBase;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.TextInputFormat;
import org.apache.flink.core.fs.Path;
import org.apache.flink.optimizer.dag.DataSourceNode;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.PlanNode;
import org.apache.flink.optimizer.plan.SourcePlanNode;
import org.junit.Assert;
import org.junit.Test;

public class ChannelTest {
    @Test
    public void testGetEstimatesNoReplicationFactor() {
        long NUM_RECORD = 1001L;
        long SIZE = 467131L;
        DataSourceNode source = ChannelTest.getSourceNode();
        SourcePlanNode planNode = new SourcePlanNode(source, "test node");
        Channel channel = new Channel((PlanNode)planNode);
        Assert.assertEquals((long)-1L, (long)channel.getEstimatedOutputSize());
        Assert.assertEquals((long)-1L, (long)channel.getEstimatedNumRecords());
        source.setEstimatedNumRecords(1001L);
        source.setEstimatedOutputSize(467131L);
        Assert.assertEquals((long)467131L, (long)channel.getEstimatedOutputSize());
        Assert.assertEquals((long)1001L, (long)channel.getEstimatedNumRecords());
    }

    @Test
    public void testGetEstimatesWithReplicationFactor() {
        long NUM_RECORD = 1001L;
        long SIZE = 467131L;
        int REPLICATION = 23;
        DataSourceNode source = ChannelTest.getSourceNode();
        SourcePlanNode planNode = new SourcePlanNode(source, "test node");
        Channel channel = new Channel((PlanNode)planNode);
        channel.setReplicationFactor(23);
        Assert.assertEquals((long)-1L, (long)channel.getEstimatedOutputSize());
        Assert.assertEquals((long)-1L, (long)channel.getEstimatedNumRecords());
        source.setEstimatedNumRecords(1001L);
        source.setEstimatedOutputSize(467131L);
        Assert.assertEquals((long)10744013L, (long)channel.getEstimatedOutputSize());
        Assert.assertEquals((long)23023L, (long)channel.getEstimatedNumRecords());
    }

    private static final DataSourceNode getSourceNode() {
        return new DataSourceNode(new GenericDataSourceBase((InputFormat)new TextInputFormat(new Path("/ignored")), new OperatorInformation((TypeInformation)BasicTypeInfo.STRING_TYPE_INFO), "source"));
    }
}

