/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.operators.util.FieldList;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.operators.CoGroupDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class CoGroupGlobalPropertiesCompatibilityTest {
    @Test
    public void checkCompatiblePartitionings() {
        try {
            FieldList keysLeft = new FieldList(new int[]{1, 4});
            FieldList keysRight = new FieldList(new int[]{3, 1});
            CoGroupDescriptor descr = new CoGroupDescriptor(keysLeft, keysRight);
            RequestedGlobalProperties reqLeft = new RequestedGlobalProperties();
            reqLeft.setHashPartitioned((FieldSet)keysLeft);
            RequestedGlobalProperties reqRight = new RequestedGlobalProperties();
            reqRight.setHashPartitioned((FieldSet)keysRight);
            GlobalProperties propsLeft = new GlobalProperties();
            propsLeft.setHashPartitioned(keysLeft);
            GlobalProperties propsRight = new GlobalProperties();
            propsRight.setHashPartitioned(keysRight);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, propsRight));
            Object part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            RequestedGlobalProperties reqLeft2 = new RequestedGlobalProperties();
            reqLeft2.setCustomPartitioned((FieldSet)keysLeft, (Partitioner)part);
            RequestedGlobalProperties reqRight2 = new RequestedGlobalProperties();
            reqRight2.setCustomPartitioned((FieldSet)keysRight, (Partitioner)part);
            GlobalProperties propsLeft2 = new GlobalProperties();
            propsLeft2.setCustomPartitioned(keysLeft, (Partitioner)part);
            GlobalProperties propsRight2 = new GlobalProperties();
            propsRight2.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft2, reqRight2, propsLeft2, propsRight2));
            part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            reqLeft2 = new RequestedGlobalProperties();
            reqLeft2.setAnyPartitioning((FieldSet)keysLeft);
            reqRight2 = new RequestedGlobalProperties();
            reqRight2.setAnyPartitioning((FieldSet)keysRight);
            propsLeft2 = new GlobalProperties();
            propsLeft2.setCustomPartitioned(keysLeft, (Partitioner)part);
            propsRight2 = new GlobalProperties();
            propsRight2.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertTrue((boolean)descr.areCompatible(reqLeft2, reqRight2, propsLeft2, propsRight2));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void checkInompatiblePartitionings() {
        try {
            FieldList keysLeft = new FieldList(1);
            FieldList keysRight = new FieldList(3);
            Partitioner<Object> part = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            Partitioner<Object> part2 = new Partitioner<Object>(){

                public int partition(Object key, int numPartitions) {
                    return 0;
                }
            };
            CoGroupDescriptor descr = new CoGroupDescriptor(keysLeft, keysRight);
            RequestedGlobalProperties reqLeft = new RequestedGlobalProperties();
            reqLeft.setAnyPartitioning((FieldSet)keysLeft);
            RequestedGlobalProperties reqRight = new RequestedGlobalProperties();
            reqRight.setAnyPartitioning((FieldSet)keysRight);
            GlobalProperties propsLeft = new GlobalProperties();
            propsLeft.setHashPartitioned(keysLeft);
            GlobalProperties propsRight = new GlobalProperties();
            propsRight.setCustomPartitioned(keysRight, (Partitioner)part);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, propsRight));
            reqLeft = new RequestedGlobalProperties();
            reqLeft.setAnyPartitioning((FieldSet)keysLeft);
            reqRight = new RequestedGlobalProperties();
            reqRight.setAnyPartitioning((FieldSet)keysRight);
            propsLeft = new GlobalProperties();
            propsLeft.setCustomPartitioned(keysLeft, (Partitioner)part);
            propsRight = new GlobalProperties();
            propsRight.setCustomPartitioned(keysRight, (Partitioner)part2);
            Assert.assertFalse((boolean)descr.areCompatible(reqLeft, reqRight, propsLeft, propsRight));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

