/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.java;

import java.util.Collections;
import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.functions.Partitioner;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.plan.OptimizedPlan;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.optimizer.plan.SinkPlanNode;
import org.apache.flink.optimizer.testfunctions.IdentityGroupReducerCombinable;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.apache.flink.runtime.operators.shipping.ShipStrategyType;
import org.junit.Assert;
import org.junit.Test;

public class PartitionOperatorTest
extends CompilerTestBase {
    @Test
    public void testPartitionOperatorPreservesFields() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource data = env.fromCollection(Collections.singleton(new Tuple2((Object)0L, (Object)0L)));
            data.partitionCustom((Partitioner)new Partitioner<Long>(){

                public int partition(Long key, int numPartitions) {
                    return key.intValue();
                }
            }, 1).groupBy(new int[]{1}).reduceGroup(new IdentityGroupReducerCombinable()).output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            OptimizedPlan op = this.compileNoStats((Plan)p);
            SinkPlanNode sink = (SinkPlanNode)op.getDataSinks().iterator().next();
            SingleInputPlanNode reducer = (SingleInputPlanNode)sink.getInput().getSource();
            SingleInputPlanNode partitioner = (SingleInputPlanNode)reducer.getInput().getSource();
            Assert.assertEquals((Object)ShipStrategyType.FORWARD, (Object)reducer.getInput().getShipStrategy());
            Assert.assertEquals((Object)ShipStrategyType.PARTITION_CUSTOM, (Object)partitioner.getInput().getShipStrategy());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

