/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.java;

import org.apache.flink.api.common.Plan;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSource;
import org.apache.flink.api.java.operators.DeltaIteration;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.translation.JavaPlan;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.optimizer.CompilerException;
import org.apache.flink.optimizer.util.CompilerTestBase;
import org.junit.Assert;
import org.junit.Test;

public class DeltaIterationDependenciesTest
extends CompilerTestBase {
    @Test
    public void testExceptionWhenNewWorksetNotDependentOnWorkset() {
        try {
            ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
            DataSource input = env.fromElements((Object[])new Tuple2[]{new Tuple2((Object)0L, (Object)0L)});
            DeltaIteration deltaIteration = input.iterateDelta((DataSet)input, 10, new int[]{0});
            JoinOperator.ProjectJoin delta = deltaIteration.getSolutionSet().join((DataSet)deltaIteration.getWorkset()).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{1}).projectSecond(new int[]{1});
            JoinOperator.ProjectJoin nextWorkset = deltaIteration.getSolutionSet().join((DataSet)input).where(new int[]{0}).equalTo(new int[]{0}).projectFirst(new int[]{1}).projectSecond(new int[]{1});
            DataSet result = deltaIteration.closeWith((DataSet)delta, (DataSet)nextWorkset);
            result.output((OutputFormat)new DiscardingOutputFormat());
            JavaPlan p = env.createProgramPlan();
            try {
                this.compileNoStats((Plan)p);
                Assert.fail((String)"Should not be able to compile, since the next workset does not depend on the workset");
            }
            catch (CompilerException compilerException) {
            }
            catch (Exception e) {
                Assert.fail((String)"wrong exception type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

