/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dataproperties;

import org.apache.flink.api.common.operators.DualInputSemanticProperties;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SemanticProperties;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.SemanticPropUtil;
import org.apache.flink.api.java.tuple.Tuple8;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.types.ByteValue;
import org.apache.flink.types.IntValue;
import org.apache.flink.types.LongValue;
import org.junit.Assert;
import org.junit.Test;

public class RequestedLocalPropertiesFilteringTest {
    private TupleTypeInfo<Tuple8<Integer, Integer, Integer, Integer, Integer, Integer, Integer, Integer>> tupleInfo = new TupleTypeInfo(new TypeInformation[]{BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO});

    @Test(expected=NullPointerException.class)
    public void testNullProps() {
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{0, 2, 3}));
        rlProp.filterBySemanticProperties(null, 0);
    }

    @Test
    public void testAllErased() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{0, 2, 3}));
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testGroupingPreserved1() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"0;2;3"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{0, 2, 3}));
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertNotNull((Object)filtered.getGroupedFields());
        Assert.assertEquals((long)3L, (long)filtered.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(3)));
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testGroupingPreserved2() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"3->0;5->2;1->3"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{0, 2, 3}));
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertNotNull((Object)filtered.getGroupedFields());
        Assert.assertEquals((long)3L, (long)filtered.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(3)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(5)));
        Assert.assertTrue((boolean)filtered.getGroupedFields().contains(Integer.valueOf(1)));
        Assert.assertNull((Object)filtered.getOrdering());
    }

    @Test
    public void testGroupingErased() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"0;2"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{0, 2, 3}));
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testOrderPreserved1() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"1;4;6"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(4), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setOrdering(o);
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertNotNull((Object)filtered.getOrdering());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getNumberOfFields());
        Assert.assertEquals((long)4L, (long)filtered.getOrdering().getFieldNumber(0).intValue());
        Assert.assertEquals((long)1L, (long)filtered.getOrdering().getFieldNumber(1).intValue());
        Assert.assertEquals((long)6L, (long)filtered.getOrdering().getFieldNumber(2).intValue());
        Assert.assertEquals(LongValue.class, (Object)filtered.getOrdering().getType(0));
        Assert.assertEquals(IntValue.class, (Object)filtered.getOrdering().getType(1));
        Assert.assertEquals(ByteValue.class, (Object)filtered.getOrdering().getType(2));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(0));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)filtered.getOrdering().getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(2));
        Assert.assertNull((Object)filtered.getGroupedFields());
    }

    @Test
    public void testOrderPreserved2() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"5->1;0->4;2->6"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(4), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setOrdering(o);
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNotNull((Object)filtered);
        Assert.assertNotNull((Object)filtered.getOrdering());
        Assert.assertEquals((long)3L, (long)filtered.getOrdering().getNumberOfFields());
        Assert.assertEquals((long)0L, (long)filtered.getOrdering().getFieldNumber(0).intValue());
        Assert.assertEquals((long)5L, (long)filtered.getOrdering().getFieldNumber(1).intValue());
        Assert.assertEquals((long)2L, (long)filtered.getOrdering().getFieldNumber(2).intValue());
        Assert.assertEquals(LongValue.class, (Object)filtered.getOrdering().getType(0));
        Assert.assertEquals(IntValue.class, (Object)filtered.getOrdering().getType(1));
        Assert.assertEquals(ByteValue.class, (Object)filtered.getOrdering().getType(2));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(0));
        Assert.assertEquals((Object)Order.ASCENDING, (Object)filtered.getOrdering().getOrder(1));
        Assert.assertEquals((Object)Order.DESCENDING, (Object)filtered.getOrdering().getOrder(2));
        Assert.assertNull((Object)filtered.getGroupedFields());
    }

    @Test
    public void testOrderErased() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"1; 4"}, null, null, this.tupleInfo, this.tupleInfo);
        Ordering o = new Ordering();
        o.appendOrdering(Integer.valueOf(4), LongValue.class, Order.DESCENDING);
        o.appendOrdering(Integer.valueOf(1), IntValue.class, Order.ASCENDING);
        o.appendOrdering(Integer.valueOf(6), ByteValue.class, Order.DESCENDING);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setOrdering(o);
        RequestedLocalProperties filtered = rlProp.filterBySemanticProperties((SemanticProperties)sProps, 0);
        Assert.assertNull((Object)filtered);
    }

    @Test
    public void testDualGroupingPreserved() {
        DualInputSemanticProperties dprops = new DualInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsDualFromString((DualInputSemanticProperties)dprops, (String[])new String[]{"1->0;3;2->4"}, (String[])new String[]{"0->7;1"}, null, null, null, null, this.tupleInfo, this.tupleInfo, this.tupleInfo);
        RequestedLocalProperties lprops1 = new RequestedLocalProperties();
        lprops1.setGroupedFields(new FieldSet(new int[]{0, 3, 4}));
        RequestedLocalProperties lprops2 = new RequestedLocalProperties();
        lprops2.setGroupedFields(new FieldSet(new int[]{7, 1}));
        RequestedLocalProperties filtered1 = lprops1.filterBySemanticProperties((SemanticProperties)dprops, 0);
        RequestedLocalProperties filtered2 = lprops2.filterBySemanticProperties((SemanticProperties)dprops, 1);
        Assert.assertNotNull((Object)filtered1);
        Assert.assertNotNull((Object)filtered1.getGroupedFields());
        Assert.assertEquals((long)3L, (long)filtered1.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered1.getGroupedFields().contains(Integer.valueOf(1)));
        Assert.assertTrue((boolean)filtered1.getGroupedFields().contains(Integer.valueOf(2)));
        Assert.assertTrue((boolean)filtered1.getGroupedFields().contains(Integer.valueOf(3)));
        Assert.assertNull((Object)filtered1.getOrdering());
        Assert.assertNotNull((Object)filtered2);
        Assert.assertNotNull((Object)filtered2.getGroupedFields());
        Assert.assertEquals((long)2L, (long)filtered2.getGroupedFields().size());
        Assert.assertTrue((boolean)filtered2.getGroupedFields().contains(Integer.valueOf(0)));
        Assert.assertTrue((boolean)filtered2.getGroupedFields().contains(Integer.valueOf(1)));
        Assert.assertNull((Object)filtered2.getOrdering());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testInvalidInputIndex() {
        SingleInputSemanticProperties sProps = new SingleInputSemanticProperties();
        SemanticPropUtil.getSemanticPropsSingleFromString((SingleInputSemanticProperties)sProps, (String[])new String[]{"1; 4"}, null, null, this.tupleInfo, this.tupleInfo);
        RequestedLocalProperties rlProp = new RequestedLocalProperties();
        rlProp.setGroupedFields(new FieldSet(new int[]{1, 4}));
        rlProp.filterBySemanticProperties((SemanticProperties)sProps, 1);
    }
}

